/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.json.internal;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.KotlinNothingValueException;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Reflection;
import logisticspipes.kotlinx.serialization.DeserializationStrategy;
import logisticspipes.kotlinx.serialization.PolymorphicSerializerKt;
import logisticspipes.kotlinx.serialization.SealedClassSerializer;
import logisticspipes.kotlinx.serialization.SerializationStrategy;
import logisticspipes.kotlinx.serialization.descriptors.PolymorphicKind;
import logisticspipes.kotlinx.serialization.descriptors.PrimitiveKind;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptor;
import logisticspipes.kotlinx.serialization.descriptors.SerialKind;
import logisticspipes.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import logisticspipes.kotlinx.serialization.internal.JsonInternalDependenciesKt;
import logisticspipes.kotlinx.serialization.json.JsonDecoder;
import logisticspipes.kotlinx.serialization.json.JsonElement;
import logisticspipes.kotlinx.serialization.json.JsonElementKt;
import logisticspipes.kotlinx.serialization.json.JsonEncoder;
import logisticspipes.kotlinx.serialization.json.JsonObject;
import logisticspipes.kotlinx.serialization.json.JsonPrimitive;
import logisticspipes.kotlinx.serialization.json.internal.JsonExceptionsKt;
import logisticspipes.kotlinx.serialization.json.internal.TreeJsonDecoderKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a%\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001a?\u0010\u0016\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0011*\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00110\f2\u0006\u0010\u0018\u001a\u0002H\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\f*\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"checkKind", "", "kind", "Llogisticspipes/kotlinx/serialization/descriptors/SerialKind;", "throwSerializerNotFound", "", "type", "", "jsonTree", "Llogisticspipes/kotlinx/serialization/json/JsonObject;", "validateIfSealed", "serializer", "Llogisticspipes/kotlinx/serialization/SerializationStrategy;", "actualSerializer", "", "classDiscriminator", "decodeSerializableValuePolymorphic", "T", "Llogisticspipes/kotlinx/serialization/json/JsonDecoder;", "deserializer", "Llogisticspipes/kotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Llogisticspipes/kotlinx/serialization/json/JsonEncoder;", "value", "ifPolymorphic", "Llogisticspipes/kotlin/Function0;", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "findActualSerializer", "logisticspipes.kotlinx-serialization-json"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value, @NotNull Function0<Unit> ifPolymorphic) {
        int $i$f$encodePolymorphically = 0;
        Intrinsics.checkNotNullParameter($this$encodePolymorphically, "$this$encodePolymorphically");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, "ifPolymorphic");
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration$kotlinx_serialization_json().useArrayPolymorphism) {
            serializer2.serialize($this$encodePolymorphically, value);
            return;
        }
        T t = value;
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        SerializationStrategy actualSerializer = PolymorphicKt.findActualSerializer($this$encodePolymorphically, serializer2, t);
        ifPolymorphic.invoke();
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final SerializationStrategy<Object> findActualSerializer(JsonEncoder $this$findActualSerializer, SerializationStrategy<Object> serializer2, Object value) {
        SerializationStrategy<Object> serializationStrategy = serializer2;
        if (serializationStrategy == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.internal.AbstractPolymorphicSerializer<kotlin.Any>");
        }
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializationStrategy;
        Object object = value;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
        }
        SerializationStrategy<Object> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, $this$findActualSerializer, object);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, $this$findActualSerializer.getJson().getConfiguration$kotlinx_serialization_json().classDiscriminator);
        SerialKind kind = actualSerializer.getDescriptor().getKind();
        PolymorphicKt.checkKind(kind);
        return actualSerializer;
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer2, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            String string = "Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because" + " it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. " + "You can either change class discriminator in JsonConfiguration, " + "rename property with @SerialName annotation or fall back to array polymorphism";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind instanceof SerialKind.ENUM) {
            String string = "Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PrimitiveKind) {
            String string = "Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PolymorphicKind) {
            String string = "Actual serializer for polymorphic cannot be polymorphic itself";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        DeserializationStrategy actualSerializer;
        void value$iv;
        Intrinsics.checkNotNullParameter($this$decodeSerializableValuePolymorphic, "$this$decodeSerializableValuePolymorphic");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration$kotlinx_serialization_json().useArrayPolymorphism) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw (Throwable)JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        String discriminator = $this$decodeSerializableValuePolymorphic.getJson().getConfiguration$kotlinx_serialization_json().classDiscriminator;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? ((JsonPrimitive)jsonElement2).getContent() : null;
        DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull($this$decodeSerializableValuePolymorphic, type);
        if (deserializationStrategy == null) {
            Void void_ = PolymorphicKt.throwSerializerNotFound(type, jsonTree);
            throw new KotlinNothingValueException();
        }
        DeserializationStrategy deserializationStrategy2 = actualSerializer = deserializationStrategy;
        if (deserializationStrategy2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T>");
        }
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, deserializationStrategy2);
    }

    private static final Void throwSerializerNotFound(String type, JsonObject jsonTree) {
        String suffix = type == null ? "missing class discriminator ('null')" : "class discriminator '" + type + '\'';
        throw (Throwable)JsonExceptionsKt.JsonDecodingException(-1, "Polymorphic serializer was not found for " + suffix, jsonTree.toString());
    }
}

