/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.coroutines.Continuation;
import logisticspipes.kotlin.coroutines.CoroutineContext;
import logisticspipes.kotlinx.coroutines.CancellableContinuation;
import logisticspipes.kotlinx.coroutines.DefaultExecutor;
import logisticspipes.kotlinx.coroutines.Delay;
import logisticspipes.kotlinx.coroutines.Dispatchers;
import logisticspipes.kotlinx.coroutines.DisposableFutureHandle;
import logisticspipes.kotlinx.coroutines.DisposableHandle;
import logisticspipes.kotlinx.coroutines.ExceptionsKt;
import logisticspipes.kotlinx.coroutines.ExecutorCoroutineDispatcher;
import logisticspipes.kotlinx.coroutines.JobKt;
import logisticspipes.kotlinx.coroutines.ResumeUndispatchedRunnable;
import logisticspipes.kotlinx.coroutines.TimeSource;
import logisticspipes.kotlinx.coroutines.TimeSourceKt;
import logisticspipes.kotlinx.coroutines.internal.ConcurrentKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016J\u001c\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0017J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J*\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Llogisticspipes/kotlinx/coroutines/ExecutorCoroutineDispatcherBase;", "Llogisticspipes/kotlinx/coroutines/ExecutorCoroutineDispatcher;", "Llogisticspipes/kotlinx/coroutines/Delay;", "()V", "removesFutureOnCancellation", "", "cancelJobOnRejection", "", "context", "Llogisticspipes/kotlin/coroutines/CoroutineContext;", "exception", "Ljava/util/concurrent/RejectedExecutionException;", "close", "dispatch", "block", "Ljava/lang/Runnable;", "Llogisticspipes/kotlinx/coroutines/Runnable;", "equals", "other", "", "hashCode", "", "initFutureCancellation", "initFutureCancellation$kotlinx_coroutines_core", "invokeOnTimeout", "Llogisticspipes/kotlinx/coroutines/DisposableHandle;", "timeMillis", "", "scheduleBlock", "Ljava/util/concurrent/ScheduledFuture;", "scheduleResumeAfterDelay", "continuation", "Llogisticspipes/kotlinx/coroutines/CancellableContinuation;", "toString", "", "logisticspipes.kotlinx-coroutines-core"})
public abstract class ExecutorCoroutineDispatcherBase
extends ExecutorCoroutineDispatcher
implements Delay {
    private boolean removesFutureOnCancellation;

    public final void initFutureCancellation$kotlinx_coroutines_core() {
        this.removesFutureOnCancellation = ConcurrentKt.removeFutureOnCancel(this.getExecutor());
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        try {
            Executor executor2 = this.getExecutor();
            boolean bl = false;
            Object object = TimeSourceKt.getTimeSource();
            if (object == null || (object = object.wrapTask(block)) == null) {
                object = block;
            }
            executor2.execute((Runnable)object);
        }
        catch (RejectedExecutionException e) {
            boolean bl = false;
            TimeSource timeSource = TimeSourceKt.getTimeSource();
            if (timeSource != null) {
                timeSource.unTrackTask();
            }
            this.cancelJobOnRejection(context, e);
            Dispatchers.getIO().dispatch(context, block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, @NotNull CancellableContinuation<? super Unit> continuation) {
        ScheduledFuture<?> future;
        ScheduledFuture<?> scheduledFuture = future = this.removesFutureOnCancellation ? this.scheduleBlock(new ResumeUndispatchedRunnable(this, continuation), continuation.getContext(), timeMillis) : null;
        if (future != null) {
            JobKt.cancelFutureOnCancellation(continuation, (Future)future);
            return;
        }
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(timeMillis, continuation);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block, @NotNull CoroutineContext context) {
        ScheduledFuture<?> future = this.removesFutureOnCancellation ? this.scheduleBlock(block, context, timeMillis) : null;
        return future != null ? (DisposableHandle)new DisposableFutureHandle((Future)future) : DefaultExecutor.INSTANCE.invokeOnTimeout(timeMillis, block, context);
    }

    private final ScheduledFuture<?> scheduleBlock(Runnable block, CoroutineContext context, long timeMillis) {
        ScheduledFuture<?> scheduledFuture;
        try {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(block, timeMillis, TimeUnit.MILLISECONDS) : null;
        }
        catch (RejectedExecutionException e) {
            this.cancelJobOnRejection(context, e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private final void cancelJobOnRejection(CoroutineContext context, RejectedExecutionException exception) {
        JobKt.cancel(context, ExceptionsKt.CancellationException("The task was rejected", exception));
    }

    @Override
    public void close() {
        block1: {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ExecutorService)) {
                executor2 = null;
            }
            ExecutorService executorService = (ExecutorService)executor2;
            if (executorService == null) break block1;
            executorService.shutdown();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherBase && ((ExecutorCoroutineDispatcherBase)other).getExecutor() == this.getExecutor();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor());
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull Continuation<? super Unit> continuation) {
        return Delay.DefaultImpls.delay(this, time, continuation);
    }
}

