/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import javax.annotation.Nonnull;
import logisticspipes.LPBlocks;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;
import org.apache.logging.log4j.Level;

public class ItemLogisticsPipe
extends LogisticsItem {
    private int newPipeIconIndex;
    private int newPipeRenderList = -1;
    private CoreUnroutedPipe dummyPipe;

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        LogisticsBlockGenericPipe block = LPBlocks.pipe;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block worldBlock = iblockstate.func_177230_c();
        if (!worldBlock.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if ((itemstack = player.func_184586_b(hand)).func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        if (!this.dummyPipe.isMultiBlock()) {
            if (player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a((Block)block, pos, false, facing, null)) {
                IBlockState state;
                CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.createPipe(this);
                if (pipe == null) {
                    LogisticsPipes.log.log(Level.WARN, "Pipe failed to create during placement at {0},{1},{2}", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                    return EnumActionResult.PASS;
                }
                if (LogisticsBlockGenericPipe.placePipe(pipe, worldIn, pos, (Block)block, null) && (state = worldIn.func_180495_p(pos)).func_177230_c() == block) {
                    block.func_180633_a(worldIn, pos, state, (EntityLivingBase)player, itemstack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
                    }
                    IBlockState newBlockState = worldIn.func_180495_p(pos);
                    SoundType soundtype = newBlockState.func_177230_c().getSoundType(newBlockState, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        CoreMultiBlockPipe multiPipe = (CoreMultiBlockPipe)this.dummyPipe;
        boolean isFreeSpace = true;
        DoubleCoordinates placeAt = new DoubleCoordinates(pos);
        LPPositionSet globalPos = new LPPositionSet(DoubleCoordinatesType.class);
        globalPos.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(placeAt, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> positions = multiPipe.getSubBlocks();
        ITubeOrientation orientation = multiPipe.getTubeOrientation(player, pos.func_177958_n(), pos.func_177952_p());
        if (orientation == null) {
            return EnumActionResult.FAIL;
        }
        orientation.rotatePositions(positions);
        positions.stream().map(iPos -> iPos.add(placeAt)).forEach(globalPos::add);
        globalPos.addToAll(orientation.getOffset());
        placeAt.add(orientation.getOffset());
        for (DoubleCoordinatesType iPos2 : globalPos) {
            if (player.func_175151_a(iPos2.getBlockPos(), facing, itemstack) && worldIn.func_190527_a((Block)block, iPos2.getBlockPos(), false, facing, null)) continue;
            TileEntity tile = worldIn.func_175625_s(iPos2.getBlockPos());
            boolean canPlace = false;
            if (tile instanceof LogisticsTileGenericSubMultiBlock && CoreMultiBlockPipe.canShare(((LogisticsTileGenericSubMultiBlock)tile).getSubTypes(), (CoreMultiBlockPipe.SubBlockTypeForShare)((Object)iPos2.getType()))) {
                canPlace = true;
            }
            if (canPlace) continue;
            isFreeSpace = false;
            break;
        }
        if (isFreeSpace) {
            IBlockState state;
            CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.createPipe(this);
            if (pipe == null) {
                LogisticsPipes.log.log(Level.WARN, "Pipe failed to create during placement at {0},{1},{2}", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                return EnumActionResult.SUCCESS;
            }
            if (LogisticsBlockGenericPipe.placePipe(pipe, worldIn, placeAt.getBlockPos(), (Block)block, orientation) && (state = worldIn.func_180495_p(placeAt.getBlockPos())).func_177230_c() == block) {
                block.func_180633_a(worldIn, pos, state, (EntityLivingBase)player, itemstack);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, placeAt.getBlockPos(), itemstack);
                }
                IBlockState newBlockState = worldIn.func_180495_p(placeAt.getBlockPos());
                SoundType soundtype = newBlockState.func_177230_c().getSoundType(newBlockState, worldIn, placeAt.getBlockPos(), (Entity)player);
                worldIn.func_184133_a(player, placeAt.getBlockPos(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPipesIcons(IIconProvider iconProvider) {
    }

    public void setPipeIconIndex(int index, int newIndex) {
        this.newPipeIconIndex = newIndex;
    }

    public int getNewPipeIconIndex() {
        return this.newPipeIconIndex;
    }

    public int getNewPipeRenderList() {
        return this.newPipeRenderList;
    }

    public void setNewPipeRenderList(int list) {
        if (this.newPipeRenderList != -1) {
            throw new UnsupportedOperationException("Can't reset this");
        }
        this.newPipeRenderList = list;
    }

    public void setDummyPipe(CoreUnroutedPipe pipe) {
        this.dummyPipe = pipe;
    }

    public CoreUnroutedPipe getDummyPipe() {
        return this.dummyPipe;
    }
}

