/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;

public class SelectItemOutOfList
extends SubGuiScreen
implements IItemSearch {
    private final List<ItemIdentifierStack> candidate;
    private final IHandleItemChoice handler;
    private ItemDisplay itemDisplay = null;
    private InputBar search;

    public SelectItemOutOfList(List<ItemIdentifierStack> candidate, IHandleItemChoice handler) {
        super(156, 188, 0, 0);
        this.candidate = candidate;
        this.handler = handler;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.guiLeft + 70, this.guiTop + 5, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(1, this.guiLeft + 138, this.guiTop + 5, 10, 10, ">"));
        this.field_146292_n.add(new GuiButton(2, this.guiLeft + 100, this.bottom - 26, 50, 20, "Select"));
        if (this.search == null) {
            this.search = new InputBar(this.field_146289_q, this.getBaseScreen(), this.guiLeft + 7, this.bottom - 23, this.right - this.guiLeft - 64, 15, false);
        }
        this.search.reposition(this.guiLeft + 7, this.bottom - 23, this.right - this.guiLeft - 64, 15);
        if (this.itemDisplay == null) {
            this.itemDisplay = new ItemDisplay(this, this.field_146289_q, this.getBaseScreen(), null, this.guiLeft + 10, this.guiTop + 18, this.xSize - 20, this.ySize - 48, 0, 0, 0, new int[]{1, 10, 64, 64}, true);
            this.itemDisplay.setItemList(this.candidate);
        }
        this.itemDisplay.reposition(this.guiLeft + 8, this.guiTop + 18, this.xSize - 16, this.ySize - 48, 0, 0);
    }

    @Override
    public void exitGui() {
        super.exitGui();
        Keyboard.enableRepeatEvents((boolean)false);
        this.getBaseScreen().func_73866_w_();
    }

    @Override
    protected void renderToolTips(int mouseX, int mouseY, float par3) {
        if (!this.hasSubGui()) {
            GuiGraphics.displayItemToolTip(this.itemDisplay.getToolTip(), (Gui)this, this.field_73735_i, 0, 0);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.field_146289_q.func_175065_a(TextUtil.translate("misc.selectType", new String[0]), (float)(this.guiLeft + 8), (float)(this.guiTop + 6), 0x404040, false);
        this.itemDisplay.renderPageNumber(this.right - 47, this.guiTop + 6);
        this.search.func_146194_f();
        this.itemDisplay.renderItemArea(this.field_73735_i);
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 1) {
            this.itemDisplay.nextPage();
        } else if (id == 0) {
            this.itemDisplay.prevPage();
        } else if (id == 2) {
            ItemIdentifierStack stack = this.itemDisplay.getSelectedItem();
            int index = this.candidate.indexOf(stack);
            if (index >= 0) {
                this.handler.handleItemChoice(index);
            }
            this.exitGui();
        }
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        this.itemDisplay.handleMouse();
        super.handleMouseInputSub();
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (!(this.itemDisplay.keyTyped(par1, par2) || par2 != 1 && this.search.handleKey(par1, par2))) {
            super.func_73869_a(par1, par2);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.itemDisplay.handleClick(mouseX, mouseY, button)) {
            return;
        }
        if (this.search.handleClick(mouseX, mouseY, button)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    @Override
    public boolean itemSearched(ItemIdentifier item) {
        if (this.search.isEmpty()) {
            return true;
        }
        if (this.isSearched(item.getFriendlyName().toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) {
            return true;
        }
        Map enchantIdLvlMap = EnchantmentHelper.func_82781_a((ItemStack)item.unsafeMakeNormalStack(1));
        for (Map.Entry e : enchantIdLvlMap.entrySet()) {
            String enchantname = ((Enchantment)e.getKey()).func_77320_a();
            if (enchantname == null || !this.isSearched(enchantname.toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean isSearched(String value, String search) {
        boolean flag = true;
        for (String s : search.split(" ")) {
            if (value.contains(s)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static interface IHandleItemChoice {
        public void handleItemChoice(int var1);
    }
}

