/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.modules;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.stream.Stream;
import logisticspipes.gui.modules.ModuleBaseGui;
import logisticspipes.kotlin.Unit;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.module.ItemSinkImportPacket;
import logisticspipes.network.packets.module.ModulePropertiesUpdate;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.GuiStringHandlerButton;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.property.BitSetProperty;
import network.rs485.logisticspipes.property.BooleanProperty;
import network.rs485.logisticspipes.property.InventoryProperty;
import network.rs485.logisticspipes.property.PropertyLayer;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.opengl.GL11;

public class GuiItemSink
extends ModuleBaseGui {
    private static final String PREFIX = "gui.itemsink.";
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/itemsink.png");
    private final PropertyLayer propertyLayer;
    private final PropertyLayer.ValuePropertyOverlay<Boolean, BooleanProperty> defaultRouteOverlay;
    private final PropertyLayer.PropertyOverlay<BitSet, BitSetProperty> ignoreDataOverlay;
    private final PropertyLayer.PropertyOverlay<BitSet, BitSetProperty> ignoreNBTOverlay;
    private final PropertyLayer.PropertyOverlay<ItemIdentifierInventory, InventoryProperty> filterInventoryOverlay;
    private final boolean isFuzzy;
    private final ModuleItemSink itemSinkModule;
    private int fuzzyPanelSelection = -1;

    public GuiItemSink(IInventory playerInventory, ModuleItemSink itemSink, boolean hasFuzzyUpgrade) {
        super(null, itemSink);
        this.isFuzzy = hasFuzzyUpgrade;
        this.itemSinkModule = itemSink;
        this.propertyLayer = new PropertyLayer(itemSink.getProperties());
        this.defaultRouteOverlay = this.propertyLayer.overlay(this.itemSinkModule.defaultRoute);
        this.filterInventoryOverlay = this.propertyLayer.overlay(this.itemSinkModule.filterInventory);
        DummyContainer dummy = new DummyContainer(playerInventory, this.propertyLayer.writeProp(this.itemSinkModule.filterInventory));
        dummy.addNormalSlotsForPlayerInventory(8, 60);
        for (int pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addDummySlot(pipeSlot, 8 + pipeSlot * 18, 18);
        }
        this.field_147002_h = dummy;
        this.field_146999_f = 175;
        this.field_147000_g = 142;
        this.ignoreDataOverlay = this.propertyLayer.overlay(this.itemSinkModule.ignoreData);
        this.ignoreNBTOverlay = this.propertyLayer.overlay(this.itemSinkModule.ignoreNBT);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiStringHandlerButton(0, this.field_146294_l / 2 + 50, this.field_146295_m / 2 - 34, 30, 20, () -> TextUtil.translate(PREFIX + (this.defaultRouteOverlay.get() != false ? "Yes" : "No"), new String[0])));
        this.field_146292_n.add(new SmallGuiButton(1, this.field_147003_i + 10, this.field_147009_r + 37, 40, 10, TextUtil.translate("gui.itemsink.import", new String[0])));
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.propertyLayer.unregister();
        if (this.field_146297_k.field_71439_g != null && !this.propertyLayer.getProperties().isEmpty()) {
            MainProxy.sendPacketToServer(ModulePropertiesUpdate.fromPropertyHolder(this.propertyLayer).setModulePos(this.module));
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        switch (guibutton.field_146127_k) {
            case 0: {
                this.defaultRouteOverlay.write(BooleanProperty::toggle);
                break;
            }
            case 1: {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkImportPacket.class).setModulePos(this.module));
            }
        }
    }

    public void importFromInventory(Stream<ItemIdentifier> items) {
        this.filterInventoryOverlay.write(filterInventory -> {
            Iterator itemsIter = items.limit(filterInventory.func_70302_i_()).iterator();
            filterInventory.func_174888_l();
            int idx = 0;
            while (itemsIter.hasNext()) {
                filterInventory.setInventorySlotContents(idx, ((ItemIdentifier)itemsIter.next()).makeStack(1));
                ++idx;
            }
            return Unit.INSTANCE;
        });
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.field_146297_k.field_71466_p.func_78276_b(this.itemSinkModule.getFilterInventory().func_70005_c_(), 8, 6, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.itemsink.Inventory", new String[0]), 8, this.field_147000_g - 92, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.itemsink.Defaultroute", new String[0]) + ":", 65, 45, 0x404040);
        if (this.isFuzzy) {
            int mx = par1 - this.field_147003_i;
            int my = par2 - this.field_147009_r;
            if (!this.isMouseInFuzzyPanel(mx, my)) {
                this.fuzzyPanelSelection = -1;
            }
            int hovered_slot = -1;
            if (my >= 18 && my <= 34 && (mx - 8) % 18 <= 16 && (mx - 8) % 18 >= 0) {
                hovered_slot = (mx - 8) / 18;
            }
            if (hovered_slot < 0 || hovered_slot >= 9) {
                hovered_slot = -1;
            }
            if (hovered_slot != -1) {
                this.fuzzyPanelSelection = hovered_slot;
            }
        }
        if (this.fuzzyPanelSelection != -1) {
            int posX = 8 + this.fuzzyPanelSelection * 18;
            int posY = 34;
            GuiGraphics.drawGuiBackGround(this.field_146297_k, posX, posY, posX + 70, posY + 27, this.field_73735_i, true, true, true, true, true);
            this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.itemsink.IgnoreData", new String[0]), posX + 4, posY + 4, !this.isIgnoreData(this.fuzzyPanelSelection) ? 0x404040 : 0xFF4040);
            this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.itemsink.IgnoreNBT", new String[0]), posX + 4, posY + 14, !this.isIgnoreNBT(this.fuzzyPanelSelection) ? 0x404040 : 0x40FF40);
        }
    }

    private boolean isIgnoreData(int pos) {
        return this.ignoreDataOverlay.read(p -> p.get(pos));
    }

    private boolean isIgnoreNBT(int pos) {
        return this.ignoreNBTOverlay.read(p -> p.get(pos));
    }

    private boolean isMouseInFuzzyPanel(int mx, int my) {
        if (this.fuzzyPanelSelection == -1) {
            return false;
        }
        int posX = 8 + this.fuzzyPanelSelection * 18;
        int posY = 34;
        return mx >= posX && my >= posY && mx <= posX + 70 && my <= posY + 27;
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int which) {
        if (this.isMouseInFuzzyPanel(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, which);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int par3) throws IOException {
        if (this.isMouseInFuzzyPanel(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            int posX = 8 + this.fuzzyPanelSelection * 18;
            int posY = 34;
            int sel = -1;
            if (mouseX - this.field_147003_i >= posX + 4 && mouseX - this.field_147003_i <= posX + 70 - 4 && mouseY - this.field_147009_r >= posY + 4 && mouseY - this.field_147009_r <= posY + 27 - 4) {
                sel = (mouseY - this.field_147009_r - posY - 4) / 11;
            }
            if (sel == 0) {
                this.ignoreDataOverlay.write(p -> {
                    p.flip(this.fuzzyPanelSelection);
                    return null;
                });
            } else if (sel == 1) {
                this.ignoreNBTOverlay.write(p -> {
                    p.flip(this.fuzzyPanelSelection);
                    return null;
                });
            }
            return;
        }
        super.func_73864_a(mouseX, mouseY, par3);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int j = this.field_147003_i;
        int k = this.field_147009_r;
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

