/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.stats;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.blocks.stats.TrackingTask;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.guis.block.StatisticsGui;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class LogisticsStatisticsTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity {
    public List<TrackingTask> tasks = new ArrayList<TrackingTask>();
    private int tickCount;
    private CoreRoutedPipe cachedConnectedPipe;

    @Override
    public void notifyOfBlockChange() {
        super.notifyOfBlockChange();
        this.cachedConnectedPipe = null;
    }

    @Override
    public void func_73660_a() {
        this.tryUpdateBlockFormat();
        if (MainProxy.isClient((IBlockAccess)this.field_145850_b)) {
            return;
        }
        ++this.tickCount;
        if (this.getConnectedPipe() == null) {
            return;
        }
        for (TrackingTask task : this.tasks) {
            task.tick(this.tickCount, this.getConnectedPipe());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int size = nbt.func_74762_e("taskSize");
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("Task_" + i);
            TrackingTask task = new TrackingTask();
            task.readFromNBT(tag);
            this.tasks.add(task);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("taskSize", this.tasks.size());
        int count2 = 0;
        for (TrackingTask task : this.tasks) {
            NBTTagCompound tag = new NBTTagCompound();
            task.writeToNBT(tag);
            nbt.func_74782_a("Task_" + count2, (NBTBase)tag);
            ++count2;
        }
        return nbt;
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(StatisticsGui.class).setTrackingList(this.tasks);
    }

    public CoreRoutedPipe getConnectedPipe() {
        if (this.cachedConnectedPipe == null) {
            new WorldCoordinatesWrapper(this).allNeighborTileEntities().stream().filter(NeighborTileEntity::isLogisticsPipe).filter(adjacent -> ((LogisticsTileGenericPipe)adjacent.getTileEntity()).pipe instanceof CoreRoutedPipe).map(adjacent -> (CoreRoutedPipe)((LogisticsTileGenericPipe)adjacent.getTileEntity()).pipe).findFirst().ifPresent(coreRoutedPipe -> {
                this.cachedConnectedPipe = coreRoutedPipe;
            });
        }
        return this.cachedConnectedPipe;
    }
}

