/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileProfiler {
    public final String title;
    private final List<String> sectionList = Lists.newArrayList();
    private final List<Long> timestampList = Lists.newArrayList();
    private final Map<String, Long> profilingMap = Maps.newHashMap();
    private final Map<String, Long> avgProfilingMap = Maps.newHashMap();
    public EntityPlayer resultPlayer;
    public boolean profilingEnabled;
    public String lastSection;
    private String profilingSection = "";
    private int cycles;

    public TileProfiler(String title) {
        this.title = title;
    }

    private static void appendMap(StringBuilder b, String tab, Map<String, Object> m) {
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getKey().equals("_v")) continue;
            Map map = (Map)e.getValue();
            b.append(tab);
            b.append(e.getKey());
            b.append(": ");
            b.append(map.get("_v"));
            b.append(" ms\n");
            TileProfiler.appendMap(b, tab + "| ", map);
        }
    }

    public void startProfiling() {
        if (this.resultPlayer != null) {
            this.profilingEnabled = true;
            this.startSection("root");
        }
    }

    public void finishProfiling() {
        --this.cycles;
        if (this.resultPlayer != null) {
            this.endSection();
            this.profilingEnabled = false;
            this.profilingMap.forEach((n, t) -> this.avgProfilingMap.merge((String)n, (Long)t, (a, b) -> (a * 3L + b) / 4L));
            this.profilingMap.clear();
            this.profilingSection = "";
            this.sectionList.clear();
        }
        if (this.cycles < 1) {
            this.sendResults();
        }
        this.lastSection = null;
    }

    public void startSection(String name) {
        if (this.profilingEnabled) {
            if (!this.profilingSection.isEmpty()) {
                this.profilingSection = this.profilingSection + ".";
            }
            this.profilingSection = this.profilingSection + name;
            this.sectionList.add(this.profilingSection);
            this.timestampList.add(System.nanoTime());
        } else {
            this.lastSection = name;
        }
    }

    public void endSection() {
        if (this.profilingEnabled) {
            long i = System.nanoTime();
            long j = this.timestampList.remove(this.timestampList.size() - 1);
            this.sectionList.remove(this.sectionList.size() - 1);
            long k = i - j;
            if (this.profilingMap.containsKey(this.profilingSection)) {
                this.profilingMap.put(this.profilingSection, this.profilingMap.get(this.profilingSection) + k);
            } else {
                this.profilingMap.put(this.profilingSection, k);
            }
            this.profilingSection = this.sectionList.isEmpty() ? "" : this.sectionList.get(this.sectionList.size() - 1);
        }
    }

    public void endStartSection(String name) {
        this.endSection();
        this.startSection(name);
    }

    public void sendResults() {
        this.profilingEnabled = false;
        if (this.resultPlayer != null) {
            StringBuilder r = new StringBuilder();
            r.append("\ufffd3===\ufffdr \ufffdeTileProfiler report (" + this.title + ")\ufffdr \ufffd3===\ufffdr\n");
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.avgProfilingMap.forEach((n, t) -> {
                Map m = map;
                String[] sp = n.split("\\.");
                for (int i = 0; i < sp.length; ++i) {
                    m = (Map)m.computeIfAbsent(sp[i], k -> new HashMap());
                }
                m.put("_v", Float.valueOf((float)(t / 1000L) / 1000.0f));
            });
            TileProfiler.appendMap(r, "", map);
            this.resultPlayer.func_145747_a((ITextComponent)new TextComponentString(r.toString()));
            this.resultPlayer = null;
        }
        this.profilingMap.clear();
        this.profilingSection = "";
        this.sectionList.clear();
        this.avgProfilingMap.clear();
    }

    public void setResultPlayer(EntityPlayer resultPlayer, int cycles) {
        this.resultPlayer = resultPlayer;
        this.cycles = cycles;
    }
}

