/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.tileentity;

import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkInvTile;
import appeng.util.InventoryAdaptor;
import appeng.util.SettingsFrom;
import appeng.util.inv.InvOperation;
import com.tom.logisticsbridge.AE2Plugin;
import com.tom.logisticsbridge.GuiHandler;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.item.VirtualPatternAE;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.part.PartSatelliteBus;
import com.tom.logisticsbridge.pipe.CraftingManager;
import com.tom.logisticsbridge.tileentity.ICraftingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityCraftingManager
extends AENetworkInvTile
implements ITickable,
ICraftingProvider,
SetIDPacket.IIdPipe,
IInventoryChangedListener,
ICraftingManager {
    private static final IItemStorageChannel ITEMS = (IItemStorageChannel)AE2Plugin.INSTANCE.api.storage().getStorageChannel(IItemStorageChannel.class);
    public String supplyID = "";
    public InventoryBasic inv = new InventoryBasic("", false, 27);
    public InvWrapper wr = new InvWrapper((IInventory)this.inv);
    private int priority;
    private List<ICraftingPatternDetails> craftingList = null;
    private final IActionSource as = new MachineSource((IActionHost)this);
    private final List<ItemStack> toInsert = new ArrayList<ItemStack>();
    private CraftingManager.BlockingMode blockingMode = CraftingManager.BlockingMode.OFF;

    public TileEntityCraftingManager() {
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.inv.func_110134_a((IInventoryChangedListener)this);
    }

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    private boolean checkBlocking() {
        switch (this.blockingMode) {
            case EMPTY_MAIN_SATELLITE: {
                if (this.supplyID.isEmpty()) {
                    return false;
                }
                PartSatelliteBus bus = this.find(this.supplyID);
                if (bus == null) {
                    return false;
                }
                InventoryAdaptor inv = bus.getHandler();
                if (inv != null) {
                    return !inv.containsItems();
                }
                return true;
            }
            case REDSTONE_HIGH: {
                return this.func_145831_w().func_175640_z(this.func_174877_v());
            }
            case REDSTONE_LOW: {
                return !this.func_145831_w().func_175640_z(this.func_174877_v());
            }
        }
        return true;
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.checkBlocking()) {
            return false;
        }
        if (patternDetails instanceof VirtualPatternAE.VirtualPatternHandler) {
            if (this.toInsert.size() > 10) {
                return false;
            }
            ItemStack stack = patternDetails.getCondensedOutputs()[0].asItemStackRepresentation();
            if (!stack.func_77942_o()) {
                return false;
            }
            String id = stack.func_77978_p().func_74779_i("__pkgDest");
            this.toInsert.add(LogisticsBridge.packageStack(patternDetails.getCondensedInputs()[0].asItemStackRepresentation(), 1, id, true));
            return true;
        }
        if (this.supplyID.isEmpty()) {
            return false;
        }
        PartSatelliteBus bus = this.find(this.supplyID);
        if (bus == null) {
            return false;
        }
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            ItemStack is = table.func_70301_a(i);
            if (is.func_190926_b() || is.func_77973_b() != LogisticsBridge.packageItem || !is.func_77942_o() || !is.func_77978_p().func_74767_n("__actStack")) continue;
            ItemStack pkgItem = new ItemStack(is.func_77978_p());
            String id = is.func_77978_p().func_74779_i("__pkgDest");
            PartSatelliteBus b = this.find(id);
            if (b == null) {
                return false;
            }
            pkgItem.func_190920_e(pkgItem.func_190916_E() * is.func_190916_E());
            if (!b.push(pkgItem)) {
                return false;
            }
            table.func_70304_b(i);
        }
        return bus.push((IInventory)table);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.getProxy().getNode() == null || stack.func_190926_b()) {
            return stack;
        }
        IStorageGrid g = (IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class);
        IMEMonitor i = g.getInventory((IStorageChannel)ITEMS);
        IAEItemStack st = (IAEItemStack)ITEMS.createStack((Object)stack);
        IAEItemStack r = (IAEItemStack)i.injectItems((IAEStack)st, simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.as);
        return r == null ? ItemStack.field_190927_a : r.createItemStack();
    }

    private PartSatelliteBus find(String id) {
        for (IGridNode node : this.getNode().getGrid().getMachines(PartSatelliteBus.class)) {
            IGridHost h = node.getMachine();
            if (!(h instanceof PartSatelliteBus)) continue;
            PartSatelliteBus satellite = (PartSatelliteBus)h;
            if (!satellite.satelliteId.equals(id)) continue;
            return satellite;
        }
        return null;
    }

    public boolean isBusy() {
        return this.supplyID.isEmpty();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getNode() != null && this.getNode().isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    @Override
    public String getPipeID(int id) {
        return id == 0 ? this.supplyID : Integer.toString(this.blockingMode.ordinal());
    }

    @Override
    public void setPipeID(int id, String pipeID, EntityPlayer player) {
        if (pipeID == null) {
            pipeID = "";
        }
        if (player == null) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setTilePos(this.getTile());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setTilePos(this.getTile());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        if (id == 0) {
            this.supplyID = pipeID;
        } else if (id == 1) {
            this.blockingMode = CraftingManager.BlockingMode.values[Math.abs(pipeID.charAt(0) - 48) % CraftingManager.BlockingMode.values.length];
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("supplyName", this.supplyID);
        compound.func_74774_a("blockingMode", (byte)this.blockingMode.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.supplyID = compound.func_74779_i("supplyName");
        this.blockingMode = CraftingManager.BlockingMode.values[Math.abs(compound.func_74771_c("blockingMode")) % CraftingManager.BlockingMode.values.length];
        super.func_145839_a(compound);
        this.updateCraftingList();
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        if (is.func_77973_b() instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b)) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            IAEItemStack[] cin = details.getCondensedInputs();
            IAEItemStack[] in = details.getInputs();
            ArrayList<ItemStack> pkgs = new ArrayList<ItemStack>();
            this.visitArray(cin, pkgs, false);
            this.visitArray(in, pkgs, false);
            pkgs.stream().map(p -> VirtualPatternAE.create(new ItemStack(p.func_77978_p()), p)).forEach(this.craftingList::add);
            this.craftingList.add(details);
        }
    }

    private void visitArray(IAEItemStack[] array, List<ItemStack> pkgs, boolean act) {
        for (int i = 0; i < array.length; ++i) {
            ItemStack is;
            IAEItemStack iaeItemStack = array[i];
            if (iaeItemStack == null || (is = iaeItemStack.getDefinition()).func_77973_b() != LogisticsBridge.packageItem || !is.func_77942_o() || is.func_77978_p().func_74767_n("__actStack") != act) continue;
            if (!act) {
                is = is.func_77946_l();
                is.func_77978_p().func_74757_a("__actStack", true);
                array[i] = (IAEItemStack)ITEMS.createStack((Object)is);
            }
            pkgs.add(is);
        }
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.inv.func_70302_i_()];
        Arrays.fill(accountedFor, (Object)false);
        assert (accountedFor.length == this.inv.func_70302_i_());
        if (!this.getProxy().isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.inv.func_70301_a(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (details instanceof VirtualPatternAE.VirtualPatternHandler) {
                    found = true;
                }
                if (found) continue;
                i.remove();
            }
            ArrayList<ItemStack> pkgs = new ArrayList<ItemStack>();
            for (ICraftingPatternDetails is : this.craftingList) {
                this.visitArray(is.getCondensedInputs(), pkgs, true);
                this.visitArray(is.getInputs(), pkgs, true);
            }
            i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                if (details instanceof VirtualPatternAE.VirtualPatternHandler) {
                    if (!pkgs.isEmpty()) {
                        IAEItemStack[] in = details.getCondensedOutputs();
                        for (int j = 0; j < in.length; ++j) {
                            ItemStack is;
                            IAEItemStack iaeItemStack = in[j];
                            ItemStack itemStack = is = iaeItemStack == null ? ItemStack.field_190927_a : iaeItemStack.asItemStackRepresentation();
                            if (is.func_190926_b() || is.func_77973_b() != LogisticsBridge.packageItem || !pkgs.stream().anyMatch(s -> ItemStack.func_77970_a((ItemStack)s, (ItemStack)is))) continue;
                            found = true;
                            break;
                        }
                    }
                } else {
                    found = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.inv.func_70301_a(x));
        }
        this.getNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getNode()));
    }

    public void func_76316_a(IInventory invBasic) {
        this.updateCraftingList();
    }

    @Override
    public String getName(int id) {
        return null;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInternalInventory() {
        return this.wr;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        NBTTagCompound tag = super.downloadSettings(from);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            tag.func_74782_a("patterns", (NBTBase)LogisticsBridge.saveAllItems((IInventory)this.inv));
            this.inv.func_174888_l();
        }
        if (!this.supplyID.isEmpty()) {
            tag.func_74778_a("satName", this.supplyID);
        }
        return tag.func_82582_d() ? null : tag;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        super.uploadSettings(from, compound);
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            LogisticsBridge.loadAllItems(compound.func_150295_c("patterns", 10), (IInventory)this.inv);
        }
        this.supplyID = compound.func_74779_i("satName");
    }

    private IGridNode getNode() {
        return this.getProxy().getNode();
    }

    public void onReady() {
        super.onReady();
        this.updateCraftingList();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.toInsert.isEmpty()) {
            ListIterator<ItemStack> itr = this.toInsert.listIterator();
            while (itr.hasNext()) {
                ItemStack stack = itr.next();
                if (stack.func_190926_b()) {
                    itr.remove();
                    continue;
                }
                ItemStack result = this.insertItem(stack, false);
                if (!result.func_190926_b()) {
                    itr.set(result);
                    continue;
                }
                itr.remove();
            }
        }
    }

    @Override
    public List<String> list(int id) {
        ArrayList<String> ret = new ArrayList<String>();
        for (IGridNode node : this.getNode().getGrid().getMachines(PartSatelliteBus.class)) {
            IGridHost h = node.getMachine();
            if (!(h instanceof PartSatelliteBus)) continue;
            PartSatelliteBus satellite = (PartSatelliteBus)h;
            ret.add(satellite.satelliteId);
        }
        return ret;
    }

    public void openGui(EntityPlayer playerIn) {
        playerIn.openGui((Object)LogisticsBridge.modInstance, GuiHandler.GuiIDs.CRAFTING_MANAGER.ordinal(), this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.supplyID).setId(0).setPosX(this.field_174879_c.func_177958_n()).setPosY(this.field_174879_c.func_177956_o()).setPosZ(this.field_174879_c.func_177952_p());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)playerIn);
    }

    @Override
    public ItemStack satelliteDisplayStack() {
        return AE2Plugin.SATELLITE_BUS_SRC.stack(1);
    }

    @Override
    public Slot createGuiSlot(int i, int x, int y) {
        return new SlotEncPattern(i, x, y);
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public CraftingManager.BlockingMode getBlockingMode() {
        return this.blockingMode;
    }

    private class SlotEncPattern
    extends Slot {
        private final Item pattern;

        public SlotEncPattern(int index, int xPosition, int yPosition) {
            super((IInventory)TileEntityCraftingManager.this.inv, index, xPosition, yPosition);
            this.pattern = AE2Plugin.INSTANCE.api.definitions().items().encodedPattern().maybeItem().orElse(Items.field_190931_a);
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() == this.pattern;
        }
    }
}

