/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.pipe;

import com.tom.logisticsbridge.GuiHandler;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.network.SyncResultNamePacket;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IItemSpaceControl;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.SatellitePipe;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.property.InventoryProperty;

public class ResultPipe
extends CoreRoutedPipe
implements SetIDPacket.IIdPipe,
IProvideItems,
IChangeListener,
SatellitePipe {
    public static final Set<ResultPipe> AllResults = Collections.newSetFromMap(new WeakHashMap());
    public static Textures.TextureType texture = Textures.empty;
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private String resultPipeName = "";
    private WeakReference<TileEntity> lastAccessedCrafter = new WeakReference<Object>(null);

    public ResultPipe(Item item) {
        super(item);
        this._orderItemManager = new LogisticsItemOrderManager((IChangeListener)this, (ILPPositionProvider)this);
    }

    public static void cleanup() {
        AllResults.clear();
    }

    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    public Textures.TextureType getCenterTexture() {
        return texture;
    }

    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.resultPipeName = nbttagcompound.func_74764_b("resultid") ? Integer.toString(nbttagcompound.func_74762_e("resultid")) : nbttagcompound.func_74779_i("resultname");
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.ensureAllSatelliteStatus();
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.resultPipeName != null) {
            nbttagcompound.func_74778_a("resultname", this.resultPipeName);
        }
        super.writeToNBT(nbttagcompound);
    }

    public void ensureAllSatelliteStatus() {
        if (this.resultPipeName.isEmpty()) {
            AllResults.remove(this);
        }
        if (!this.resultPipeName.isEmpty()) {
            AllResults.add(this);
        }
    }

    public void onAllowedRemoval() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        AllResults.remove(this);
        while (this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            this._orderItemManager.sendFailed();
        }
    }

    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = ((SyncResultNamePacket)PacketHandler.getPacket(SyncResultNamePacket.class)).setString(this.resultPipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)entityplayer);
        entityplayer.openGui((Object)LogisticsBridge.modInstance, GuiHandler.GuiIDs.RESULT_PIPE.ordinal(), this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void setPipeID(int fid, String integer, EntityPlayer player) {
        if (player == null) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(integer).setId(fid).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(integer).setId(fid).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        this.resultPipeName = integer;
        this.ensureAllSatelliteStatus();
    }

    @Override
    public String getPipeID(int fid) {
        return this.resultPipeName;
    }

    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filter) {
        System.out.println("ResultPipe.canProvide()");
    }

    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (promise instanceof LogisticsExtraDictPromise) {
            this.getItemOrderManager().removeExtras(((LogisticsExtraDictPromise)promise).getResource());
        }
        if (promise instanceof LogisticsExtraPromise) {
            this.getItemOrderManager().removeExtras(new DictResource(new ItemIdentifierStack(promise.item, promise.numberOfItems), null));
        }
        if (promise instanceof LogisticsDictPromise) {
            this.spawnParticle(Particles.WhiteParticle, 2);
            return this.getItemOrderManager().addOrder(((LogisticsDictPromise)promise).getResource(), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        this.spawnParticle(Particles.WhiteParticle, 2);
        return this.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
    }

    public void enabledUpdateEntity() {
        if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            if (this.isNthTick(6)) {
                this.cacheAreAllOrderesToBuffer();
            }
            if (this.getItemOrderManager().isFirstOrderWatched()) {
                TileEntity tile = (TileEntity)this.lastAccessedCrafter.get();
                if (tile != null) {
                    this.getItemOrderManager().setMachineProgress(SimpleServiceLocator.machineProgressProvider.getProgressForTile(tile));
                } else {
                    this.getItemOrderManager().setMachineProgress((byte)0);
                }
            }
        }
        if (!this.isNthTick(6)) {
            return;
        }
        if (!this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            return;
        }
        List adjacentInventories = this.getAvailableAdjacent().inventories();
        if (adjacentInventories.isEmpty()) {
            if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
                this.getItemOrderManager().sendFailed();
            }
            return;
        }
        this.spawnParticle(Particles.VioletParticle, 2);
        int il = this.itemsToExtract();
        int sl = this.stacksToExtract();
        block0: while (il > 0 && sl > 0 && this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            NeighborTileEntity adjacentCrafter;
            LogisticsItemOrder nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA});
            int mts = Math.min(il, nextOrder.getResource().stack.getStackSize());
            mts = Math.min(nextOrder.getResource().getItem().getMaxStackSize(), mts);
            ItemStack extracted = ItemStack.field_190927_a;
            NeighborTileEntity adjacent = null;
            Iterator iterator = adjacentInventories.iterator();
            while (iterator.hasNext() && (extracted = this.extract((NeighborTileEntity<TileEntity>)(adjacent = (adjacentCrafter = (NeighborTileEntity)iterator.next())), (IResource)nextOrder.getResource(), mts)).func_190926_b()) {
            }
            if (extracted.func_190926_b()) {
                this.getItemOrderManager().deferSend();
                break;
            }
            this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            Objects.requireNonNull(adjacent);
            this.lastAccessedCrafter = new WeakReference<TileEntity>(adjacent.getTileEntity());
            ItemIdentifier extractedID = ItemIdentifier.get((ItemStack)extracted);
            while (!extracted.func_190926_b()) {
                if (this.isExtractedMismatch(nextOrder, extractedID)) {
                    LogisticsItemOrder startOrder = nextOrder;
                    if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
                        do {
                            this.getItemOrderManager().deferSend();
                        } while (this.isExtractedMismatch(nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA}), extractedID) && startOrder != nextOrder);
                    }
                    if (startOrder == nextOrder) {
                        int nts = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                        if (nts == 0) continue block0;
                        --sl;
                        il -= nts;
                        ItemStack stackToSend = extracted.func_77979_a(nts);
                        this.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, null, adjacent.getDirection());
                        continue;
                    }
                }
                int nts = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                if ((nts = Math.min(nts, nextOrder.getResource().stack.getStackSize())) == 0) continue block0;
                --sl;
                il -= nts;
                ItemStack stackToSend = extracted.func_77979_a(nts);
                if (nextOrder.getDestination() != null) {
                    SinkReply reply = LogisticsManager.canSink((ItemStack)stackToSend, (IRouter)nextOrder.getDestination().getRouter(), null, (boolean)true, (ItemIdentifier)ItemIdentifier.get((ItemStack)stackToSend), null, (boolean)true, (boolean)false);
                    boolean ds = reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1;
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend);
                    item.setDestination(nextOrder.getDestination().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.setAdditionalTargetInformation(nextOrder.getInformation());
                    this.queueRoutedItem((IRoutedItem)item, adjacent.getDirection());
                    this.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), ds, (IRoutedItem)item);
                } else {
                    this.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, nextOrder.getInformation(), adjacent.getDirection());
                    this.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), false, null);
                }
                if (!this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) continue;
                nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA});
            }
        }
    }

    private boolean isExtractedMismatch(LogisticsItemOrder nextOrder, ItemIdentifier extractedID) {
        return !nextOrder.getResource().getItem().equals(extractedID) && (!this.getUpgradeManager().isFuzzyUpgrade() || nextOrder.getResource().getBitSet().nextSetBit(0) == -1 || !nextOrder.getResource().matches(extractedID, IResource.MatchSettings.NORMAL));
    }

    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter) {
    }

    public void listenedChanged() {
    }

    public boolean cacheAreAllOrderesToBuffer() {
        for (LogisticsItemOrder order : this.getItemOrderManager()) {
            SinkReply reply;
            if (order.getDestination() instanceof IItemSpaceControl && ((reply = LogisticsManager.canSink((ItemStack)order.getResource().getItemStack().makeNormalStack(), (IRouter)order.getDestination().getRouter(), null, (boolean)true, (ItemIdentifier)order.getResource().getItem(), null, (boolean)true, (boolean)false)) == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1)) continue;
            return false;
        }
        return true;
    }

    protected int neededEnergy() {
        return (int)(10.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    @Nonnull
    private ItemStack extract(NeighborTileEntity<TileEntity> adjacent, IResource item, int amount) {
        IInventoryUtil invUtil = LPNeighborTileEntityKt.getInventoryUtil(adjacent);
        if (invUtil == null) {
            return ItemStack.field_190927_a;
        }
        return this.extractFromInventory(invUtil, item, amount);
    }

    @Nonnull
    private ItemStack extractFromInventory(@Nonnull IInventoryUtil invUtil, IResource wanteditem, int count) {
        ItemIdentifier itemToExtract = null;
        if (wanteditem instanceof ItemResource) {
            itemToExtract = ((ItemResource)wanteditem).getItem();
        } else if (wanteditem instanceof DictResource) {
            int max = Integer.MIN_VALUE;
            ItemIdentifier toExtract = null;
            for (Map.Entry content : invUtil.getItemsAndCount().entrySet()) {
                if (!wanteditem.matches((ItemIdentifier)content.getKey(), IResource.MatchSettings.NORMAL) || (Integer)content.getValue() <= max) continue;
                max = (Integer)content.getValue();
                toExtract = (ItemIdentifier)content.getKey();
            }
            if (toExtract == null) {
                return ItemStack.field_190927_a;
            }
            itemToExtract = toExtract;
        }
        if (itemToExtract == null) {
            return ItemStack.field_190927_a;
        }
        int available = invUtil.itemCount(itemToExtract);
        if (available == 0 || !this.canUseEnergy(this.neededEnergy() * Math.min(count, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(itemToExtract, Math.min(count, available));
        this.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    @Nonnull
    private ItemStack extractFromInventoryFiltered(@Nonnull IInventoryUtil invUtil, IItemIdentifierInventory filter, boolean isExcluded, int filterInvLimit) {
        ItemIdentifier wi = null;
        boolean found = false;
        for (ItemIdentifier item : invUtil.getItemsAndCount().keySet()) {
            found = this.isFiltered(filter, filterInvLimit, item, found);
            if (isExcluded == found) continue;
            wi = item;
            break;
        }
        if (wi == null) {
            return ItemStack.field_190927_a;
        }
        int available = invUtil.itemCount(wi);
        if (available == 0 || !this.canUseEnergy(this.neededEnergy() * Math.min(64, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(wi, Math.min(64, available));
        this.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    private boolean isFiltered(IItemIdentifierInventory filter, int filterInvLimit, ItemIdentifier item, boolean found) {
        for (int i = 0; i < filter.func_70302_i_() && i < filterInvLimit; ++i) {
            ItemIdentifierStack identStack = filter.getIDStackInSlot(i);
            if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public String getName(int id) {
        return "gui.resultPipe.id";
    }

    public void registerExtras(IPromise promise) {
        if (promise instanceof LogisticsDictPromise) {
            this.getItemOrderManager().addExtra(((LogisticsDictPromise)promise).getResource());
        } else {
            ItemIdentifierStack stack = new ItemIdentifierStack(promise.getItemType(), promise.getAmount());
            this.getItemOrderManager().addExtra(new DictResource(stack, null));
        }
    }

    public String getResultPipeName() {
        return this.resultPipeName;
    }

    public void extractCleanup(InventoryProperty cleanupInventory, boolean cleanupModeIsExclude, int i) {
        ISlotUpgradeManager upgradeManager;
        List adjacentInventories = this.getAvailableAdjacent().inventories();
        if (!this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA}) && (upgradeManager = (ISlotUpgradeManager)Objects.requireNonNull(this.getUpgradeManager())).getCrafterCleanup() > 0) {
            adjacentInventories.stream().map(neighbor -> this.extractFiltered((NeighborTileEntity<TileEntity>)neighbor, (IItemIdentifierInventory)cleanupInventory, cleanupModeIsExclude, upgradeManager.getCrafterCleanup() * 3)).filter(stack -> !stack.func_190926_b()).findFirst().ifPresent(extracted -> {
                this.queueRoutedItem((IRoutedItem)SimpleServiceLocator.routedItemHelper.createNewTravelItem(extracted), EnumFacing.UP);
                this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            });
        }
    }

    @Nonnull
    private ItemStack extractFiltered(NeighborTileEntity<TileEntity> neighbor, IItemIdentifierInventory inv, boolean isExcluded, int filterInvLimit) {
        IInventoryUtil invUtil = LPNeighborTileEntityKt.getInventoryUtil(neighbor);
        if (invUtil == null) {
            return ItemStack.field_190927_a;
        }
        return this.extractFromInventoryFiltered(invUtil, inv, isExcluded, filterInvLimit);
    }

    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = ((SyncResultNamePacket)PacketHandler.getPacket(SyncResultNamePacket.class)).setString(this.resultPipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    public List<ItemIdentifierStack> getItemList() {
        return Collections.emptyList();
    }

    public String getSatellitePipeName() {
        return this.resultPipeName;
    }

    public void setSatellitePipeName(@Nonnull String s) {
        this.resultPipeName = s;
    }

    public Set<SatellitePipe> getSatellitesOfType() {
        return Collections.unmodifiableSet(AllResults);
    }

    public void updateWatchers() {
        CoordinatesPacket packet = ((SyncResultNamePacket)PacketHandler.getPacket(SyncResultNamePacket.class)).setString(this.resultPipeName).setTilePos((TileEntity)this.getContainer());
        MainProxy.sendToPlayerList((ModernPacket)packet, (PlayerCollectionList)this.localModeWatchers);
        MainProxy.sendPacketToAllWatchingChunk((TileEntity)this.getContainer(), (ModernPacket)packet);
    }
}

