/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.pipe;

import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.api.BridgeStack;
import com.tom.logisticsbridge.tileentity.IBridge;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.LPNeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class BridgePipe
extends CoreRoutedPipe
implements IProvideItems,
IRequestItems,
IChangeListener,
ICraftItems,
IRequireReliableTransport {
    public static Textures.TextureType TEXTURE = Textures.empty;
    private static Consumer<RequestTreeNode> recurseFailedRequestTree;
    private static final Function<RequestTreeNode, List<RequestTreeNode>> subRequests;
    private static final Function<RequestTreeNode, List<IExtraPromise>> extrapromises;
    public boolean isDefaultRoute;
    private final BPModule itemSinkModule;
    private IBridge bridge;
    private EnumFacing dir;
    private final Req req = new Req();

    public BridgePipe(Item item) {
        super(item);
        this._orderItemManager = new LogisticsItemOrderManager((IChangeListener)this, (ILPPositionProvider)this);
        this.itemSinkModule = new BPModule();
        this.itemSinkModule.registerHandler((IWorldProvider)this, (IPipeServiceProvider)this);
    }

    public static boolean request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, IAdditionalTargetInformation info) {
        return RequestTree.request((ItemIdentifierStack)item, (IRequestItems)requester, (RequestLog)log, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (EnumSet)RequestTree.defaultRequestFlags, (IAdditionalTargetInformation)info) == item.getStackSize();
    }

    public static void listExras(RequestTreeNode node, List<IExtraPromise> list) {
        list.addAll((Collection<IExtraPromise>)extrapromises.apply(node));
        subRequests.apply(node).forEach(n -> BridgePipe.listExras(n, list));
    }

    public void setTile(TileEntity tile) {
        super.setTile(tile);
        this.itemSinkModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    public Textures.TextureType getCenterTexture() {
        return TEXTURE;
    }

    public LogisticsModule getLogisticsModule() {
        return this.itemSinkModule;
    }

    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled() || this.bridge == null || this.canCraft(tree.getRequestType())) {
            return;
        }
        if (tree.getRequestType() instanceof ItemResource) {
            ItemIdentifier item = ((ItemResource)tree.getRequestType()).getItem();
            for (IFilter filter : filters) {
                if (filter.isBlocked() != filter.isFilteredItem(item.getUndamaged()) && !filter.blockProvider()) continue;
                return;
            }
            int canProvide = this.getAvailableItemCount(item);
            if ((canProvide -= root.getAllPromissesFor((IProvide)this, item)) < 1) {
                return;
            }
            tree.addPromise((IPromise)new LogisticsPromise(item, Math.min(canProvide, tree.getMissingAmount()), (IProvideItems)this, IOrderInfoProvider.ResourceType.PROVIDER));
        } else if (tree.getRequestType() instanceof DictResource) {
            DictResource dict = (DictResource)tree.getRequestType();
            HashMap<ItemIdentifier, Integer> available = new HashMap<ItemIdentifier, Integer>();
            this.getAllItems(available, filters);
            for (Map.Entry<ItemIdentifier, Integer> item : available.entrySet()) {
                if (!dict.matches(item.getKey(), IResource.MatchSettings.NORMAL)) continue;
                int canProvide = this.getAvailableItemCount(item.getKey());
                if ((canProvide -= root.getAllPromissesFor((IProvide)this, item.getKey())) < 1) continue;
                tree.addPromise((IPromise)new LogisticsPromise(item.getKey(), Math.min(canProvide, tree.getMissingAmount()), (IProvideItems)this, IOrderInfoProvider.ResourceType.PROVIDER));
                if (tree.getMissingAmount() > 0) continue;
                break;
            }
        }
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.itemCount(item) - this._orderItemManager.totalItemsCountInOrders(item);
    }

    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (destination == this || this.bridge == null) {
            return null;
        }
        this.spawnParticle(Particles.WhiteParticle, 2);
        long count = this.bridge.countItem(promise.item.makeNormalStack(1), true);
        if (count < (long)promise.numberOfItems) {
            this.bridge.craftStack(promise.item.makeNormalStack(1), (int)((long)promise.numberOfItems - count), false);
            return this._orderItemManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        return this._orderItemManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.PROVIDER, info);
    }

    public void enabledUpdateEntity() {
        int sent;
        super.enabledUpdateEntity();
        if (this.isNthTick(10)) {
            WorldCoordinatesWrapper w = new WorldCoordinatesWrapper((TileEntity)this.container);
            LPNeighborTileEntity ate = null;
            for (EnumFacing f : EnumFacing.field_176754_o) {
                LPNeighborTileEntity n = w.getNeighbor(f);
                if (n == null || !(n.getTileEntity() instanceof IBridge)) continue;
                ate = n;
            }
            if (ate == null) {
                this.dir = null;
                this.bridge = null;
            } else {
                this.dir = ate.getDirection();
                this.bridge = (IBridge)ate.getTileEntity();
                this.bridge.setReqAPI(this.req);
            }
        }
        if (!this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.PROVIDER, IOrderInfoProvider.ResourceType.CRAFTING}) || this.getWorld().func_82737_E() % 6L != 0L) {
            return;
        }
        int il = this.itemsToExtract();
        int sl = this.stacksToExtract();
        LogisticsItemOrder firstOrder = null;
        LogisticsItemOrder order = null;
        while (il > 0 && sl > 0 && this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING}) && (firstOrder == null || firstOrder != order)) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((order = (LogisticsItemOrder)this._orderItemManager.peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING})) == null) break;
            sent = this.sendStack(order.getResource().stack, il, order.getRouter().getSimpleID(), order.getInformation(), false);
            this.spawnParticle(Particles.VioletParticle, 2);
            if (sent < 0) continue;
            --sl;
            il -= sent;
        }
        while (il > 0 && sl > 0 && this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.PROVIDER}) && (firstOrder == null || firstOrder != order)) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((order = (LogisticsItemOrder)this._orderItemManager.peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.PROVIDER})) == null || (sent = this.sendStack(order.getResource().stack, il, order.getRouter().getSimpleID(), order.getInformation(), true)) < 0) break;
            this.spawnParticle(Particles.VioletParticle, 3);
            --sl;
            il -= sent;
        }
    }

    protected int neededEnergy() {
        return (int)(10.0 * Math.pow(1.1, this.upgradeManager.getItemExtractionUpgrade()) * Math.pow(1.2, this.upgradeManager.getItemStackExtractionUpgrade()) * 2.0);
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.upgradeManager.getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.upgradeManager.getItemStackExtractionUpgrade();
    }

    private int sendStack(ItemIdentifierStack stack, int maxCount, int destination, IAdditionalTargetInformation info, boolean setFailed) {
        ItemIdentifier item = stack.getItem();
        int available = this.itemCount(item);
        if (available == 0) {
            if (setFailed) {
                this._orderItemManager.sendFailed();
            } else {
                this._orderItemManager.deferSend();
            }
            return 0;
        }
        int wanted = Math.min(available, stack.getStackSize());
        wanted = Math.min(wanted, maxCount);
        wanted = Math.min(wanted, item.getMaxStackSize());
        if (!MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this._orderItemManager.sendFailed();
            return 0;
        }
        ServerRouter dRtr = SimpleServiceLocator.routerManager.getServerRouter(destination);
        if (dRtr == null) {
            this._orderItemManager.sendFailed();
            return 0;
        }
        SinkReply reply = LogisticsManager.canSink((ItemStack)stack.makeNormalStack(), (IRouter)dRtr, null, (boolean)true, (ItemIdentifier)stack.getItem(), null, (boolean)true, (boolean)false);
        boolean defersend = false;
        if (reply != null && reply.maxNumberOfItems < wanted) {
            wanted = reply.maxNumberOfItems;
            if (wanted <= 0) {
                this._orderItemManager.deferSend();
                return 0;
            }
            defersend = true;
        }
        if (!this.canUseEnergy(wanted * this.neededEnergy())) {
            return -1;
        }
        ItemStack removed = this.getMultipleItems(item, wanted);
        if (removed == null || removed.func_190916_E() == 0) {
            if (setFailed) {
                this._orderItemManager.sendFailed();
            } else {
                this._orderItemManager.deferSend();
            }
            return 0;
        }
        int sent = removed.func_190916_E();
        this.useEnergy(sent * this.neededEnergy());
        LPTravelingItem.LPTravelingItemServer routedItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(removed);
        routedItem.setDestination(destination);
        routedItem.setTransportMode(IRoutedItem.TransportMode.Active);
        routedItem.setAdditionalTargetInformation(info);
        super.queueRoutedItem((IRoutedItem)routedItem, this.dir != null ? this.dir : EnumFacing.UP);
        this._orderItemManager.sendSuccessfull(sent, defersend, (IRoutedItem)routedItem);
        return sent;
    }

    public void onAllowedRemoval() {
        while (this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.PROVIDER})) {
            this._orderItemManager.sendFailed();
        }
    }

    public void getAllItems(Map<ItemIdentifier, Integer> items, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        HashMap addedItems = new HashMap();
        this.getItemsAndCount().entrySet().stream().filter(i -> {
            for (IFilter filter : filters) {
                if (filter.isBlocked() != filter.isFilteredItem(((ItemIdentifier)i.getKey()).getUndamaged()) && !filter.blockProvider()) continue;
                return false;
            }
            return true;
        }).forEach(next -> addedItems.merge(next.getKey(), next.getValue(), (a, b) -> a + b));
        for (Map.Entry item : addedItems.entrySet()) {
            int remaining = (Integer)item.getValue() - this._orderItemManager.totalItemsCountInOrders((ItemIdentifier)item.getKey());
            if (remaining < 1) continue;
            items.put((ItemIdentifier)item.getKey(), remaining);
        }
    }

    public boolean hasGenericInterests() {
        return true;
    }

    public int itemCount(ItemIdentifier item) {
        if (this.bridge == null) {
            return 0;
        }
        return (int)this.bridge.countItem(item.makeNormalStack(1), true);
    }

    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        if (this.bridge == null) {
            return Collections.emptyMap();
        }
        List<ItemStack> prov = this.req.getProvidedItems();
        return this.bridge.getItems().stream().filter(st -> prov.stream().noneMatch(s -> s.func_77969_a((ItemStack)st.obj) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)((ItemStack)st.obj)))).map(s -> new BridgeStack<ItemIdentifier>(ItemIdentifier.get((ItemStack)((ItemStack)s.obj)), s.size + s.requestableSize, s.craftable, 0L)).collect(Collectors.toMap(s -> (ItemIdentifier)s.obj, s -> (int)s.size, Integer::sum, HashMap::new));
    }

    public ItemStack getMultipleItems(ItemIdentifier item, int count) {
        if (this.bridge == null) {
            return ItemStack.field_190927_a;
        }
        return this.bridge.extractStack(item.makeNormalStack(1), count, false);
    }

    public boolean logisitcsIsPipeConnected(TileEntity tile, EnumFacing dir) {
        return tile instanceof IBridge;
    }

    public void registerExtras(IPromise promise) {
    }

    public ICraftingTemplate addCrafting(IResource type) {
        if (this.bridge == null) {
            return null;
        }
        ItemStack item = type.getAsItem().makeNormalStack(1);
        List<ItemStack> cr = this.req.getCraftedItems();
        if (this.bridge.getItems().stream().noneMatch(b -> {
            if (!b.craftable) return false;
            if (!item.func_77969_a((ItemStack)b.obj)) return false;
            if (!cr.stream().noneMatch(arg_0 -> ((ItemStack)item).func_77969_a(arg_0))) return false;
            return true;
        })) {
            return null;
        }
        return new ItemCraftingTemplate(type.getAsItem().makeStack(type.getRequestedAmount()), (ICraftItems)this, 0);
    }

    public boolean canCraft(IResource toCraft) {
        if (!this.isEnabled()) {
            return false;
        }
        ItemStack item = toCraft.getAsItem().makeNormalStack(1);
        List<ItemStack> cr = this.req.getCraftedItems();
        return this.bridge.getItems().stream().anyMatch(b -> b.craftable && item.func_77969_a((ItemStack)b.obj) && !cr.stream().anyMatch(i -> item.func_77969_a(i)));
    }

    public void listenedChanged() {
    }

    public int getTodo() {
        return 0;
    }

    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    public List<ItemIdentifierStack> getCraftedItems() {
        if (this.bridge == null) {
            return Collections.emptyList();
        }
        return this.bridge.getItems().stream().filter(b -> b.craftable).map(s -> new ItemIdentifierStack(ItemIdentifier.get((ItemStack)((ItemStack)s.obj)), 1)).collect(Collectors.toList());
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("isDefaultRoute", this.isDefaultRoute);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.isDefaultRoute = nbttagcompound.func_74767_n("isDefaultRoute");
    }

    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (!this.getWorld().field_72995_K) {
            this.isDefaultRoute = !this.isDefaultRoute;
            entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("chat.logisticsbridge.bridgeDefaultRoute", new Object[]{new TextComponentTranslation("gui.itemsink." + (this.isDefaultRoute ? "Yes" : "No"), new Object[0])}));
        }
    }

    static {
        try {
            Method m = RequestTreeNode.class.getDeclaredMethod("recurseFailedRequestTree", new Class[0]);
            m.setAccessible(true);
            Field srf = RequestTreeNode.class.getDeclaredField("subRequests");
            Field ef = RequestTreeNode.class.getDeclaredField("extrapromises");
            Constructor lookupCons = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            lookupCons.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)lookupCons.newInstance(RequestTreeNode.class);
            MethodType imct = MethodType.methodType(Void.TYPE, Object.class);
            MethodHandle mh = lookup.unreflect(m);
            try {
                recurseFailedRequestTree = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(Consumer.class), imct, mh, mh.type()).getTarget().invoke();
            }
            catch (Exception e) {
                e.printStackTrace();
                recurseFailedRequestTree = rtn -> {
                    try {
                        m.invoke(rtn, new Object[0]);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                };
            }
            MethodHandle srm = lookup.unreflectGetter(srf);
            MethodHandle em = lookup.unreflectGetter(ef);
            subRequests = t -> {
                try {
                    return srm.invoke((RequestTreeNode)t);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            };
            extrapromises = t -> {
                try {
                    return em.invoke((RequestTreeNode)t);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            };
            LogisticsBridge.log.info("Initialized reflection in Bridge Pipe");
        }
        catch (Throwable e) {
            throw new RuntimeException("Missing methods in LP", e);
        }
    }

    public class BPModule
    extends LogisticsModule {
        private SinkReply sr;
        private SinkReply srd;

        @Nonnull
        public String getLPName() {
            return "bridge";
        }

        public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
            super.registerPosition(slot, positionInt);
            this.sr = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, (IAdditionalTargetInformation)new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
            this.srd = new SinkReply(SinkReply.FixedPriority.DefaultRoute, 0, true, true, 1, 0, (IAdditionalTargetInformation)new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
        }

        public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
            if (BridgePipe.this.isDefaultRoute && !allowDefault) {
                return null;
            }
            if (bestPriority > this.sr.fixedPriority.ordinal() || bestPriority == this.sr.fixedPriority.ordinal() && bestCustomPriority >= this.sr.customPriority) {
                return null;
            }
            if (BridgePipe.this.isDefaultRoute) {
                if (bestPriority > this.srd.fixedPriority.ordinal() || bestPriority == this.srd.fixedPriority.ordinal() && bestCustomPriority >= this.srd.customPriority) {
                    return null;
                }
                if (this._service.canUseEnergy(1)) {
                    return this.srd;
                }
                return null;
            }
            return null;
        }

        public boolean hasGenericInterests() {
            return BridgePipe.this.isDefaultRoute;
        }

        public void tick() {
        }

        public void readFromNBT(NBTTagCompound nbttagcompound) {
        }

        public void writeToNBT(NBTTagCompound nbttagcompound) {
        }

        public boolean interestedInAttachedInventory() {
            return false;
        }

        public boolean interestedInUndamagedID() {
            return false;
        }

        public boolean recievePassive() {
            return true;
        }
    }

    public class Req {
        private boolean alreadyProcessing;
        private final Set<ItemIdentifier> craftedStacks = new HashSet<ItemIdentifier>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ItemStack> getProvidedItems() {
            if (this.alreadyProcessing || !BridgePipe.this.isEnabled()) {
                return Collections.emptyList();
            }
            if (BridgePipe.this.stillNeedReplace()) {
                return new ArrayList<ItemStack>();
            }
            try {
                this.alreadyProcessing = true;
                IRouter myRouter = BridgePipe.this.getRouter();
                ArrayList<ExitRoute> exits = new ArrayList<ExitRoute>(myRouter.getIRoutersByCost());
                exits.removeIf(e -> e.destination == myRouter);
                Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(exits);
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
                for (Map.Entry item : items.entrySet()) {
                    ItemStack is = ((ItemIdentifier)item.getKey()).unsafeMakeNormalStack(((Integer)item.getValue()).intValue());
                    list.add(is);
                }
                ArrayList<ItemStack> arrayList = list;
                return arrayList;
            }
            finally {
                this.alreadyProcessing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ItemStack> getCraftedItems() {
            if (this.alreadyProcessing || !BridgePipe.this.isEnabled()) {
                return Collections.emptyList();
            }
            if (BridgePipe.this.stillNeedReplace()) {
                return new ArrayList<ItemStack>();
            }
            try {
                this.alreadyProcessing = true;
                IRouter myRouter = BridgePipe.this.getRouter();
                ArrayList<ExitRoute> exits = new ArrayList<ExitRoute>(myRouter.getIRoutersByCost());
                exits.removeIf(e -> e.destination == myRouter);
                LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(exits);
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
                for (ItemIdentifier item : items) {
                    ItemStack is = item.unsafeMakeNormalStack(1);
                    list.add(is);
                }
                ArrayList<ItemStack> arrayList = list;
                return arrayList;
            }
            finally {
                this.alreadyProcessing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OpResult simulateRequest(ItemStack wanted, int craft, boolean allowPartial) {
            if (!BridgePipe.this.isEnabled() || this.alreadyProcessing) {
                OpResult r = new OpResult();
                r.used = Collections.emptyList();
                r.missing = Collections.singletonList(wanted);
                return r;
            }
            this.alreadyProcessing = true;
            try {
                IRouter myRouter = BridgePipe.this.getRouter();
                ArrayList<ExitRoute> exits = new ArrayList<ExitRoute>(myRouter.getIRoutersByCost());
                exits.removeIf(e -> e.destination == myRouter);
                Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(exits);
                int count = items.getOrDefault(ItemIdentifier.get((ItemStack)wanted), 0);
                if (count == 0 && craft == 0) {
                    OpResult r = new OpResult();
                    r.used = Collections.emptyList();
                    r.missing = Collections.singletonList(wanted);
                    OpResult opResult = r;
                    return opResult;
                }
                ListLog ll = new ListLog();
                ItemIdentifierStack item = ItemIdentifier.get((ItemStack)wanted).makeStack(craft != 0 ? wanted.func_190916_E() : Math.min(count, wanted.func_190916_E()));
                ItemResource reqRes = new ItemResource(item, (IRequestItems)BridgePipe.this);
                RequestTree tree = new RequestTree((IResource)reqRes, null, (craft & 2) != 0 ? EnumSet.of(RequestTree.ActiveRequestType.Craft) : RequestTree.defaultRequestFlags, null);
                if (!tree.isDone()) {
                    recurseFailedRequestTree.accept(tree);
                }
                tree.sendUsedMessage((RequestLog)ll);
                OpResult res = ll.asResult();
                if ((craft & 4) != 0 && BridgePipe.this.isDefaultRoute) {
                    ArrayList<IExtraPromise> extrasPromises = new ArrayList<IExtraPromise>();
                    BridgePipe.listExras((RequestTreeNode)tree, extrasPromises);
                    res.extra = extrasPromises.stream().map(e -> e.getItemType().makeNormalStack(e.getAmount())).collect(Collectors.toList());
                }
                if (craft == 0 && !allowPartial && wanted.func_190916_E() > count) {
                    int missingCount = wanted.func_190916_E() - count;
                    ItemStack missingStack = wanted.func_77946_l();
                    missingStack.func_190920_e(missingCount);
                    res.missing.add(missingStack);
                }
                OpResult opResult = res;
                return opResult;
            }
            finally {
                this.alreadyProcessing = false;
            }
        }

        public OpResult performRequest(ItemStack wanted, boolean craft) {
            if (!BridgePipe.this.isEnabled()) {
                return new OpResult(Collections.singletonList(wanted));
            }
            ListLog ll = new ListLog();
            IRouter myRouter = BridgePipe.this.getRouter();
            ArrayList<ExitRoute> exits = new ArrayList<ExitRoute>(myRouter.getIRoutersByCost());
            exits.removeIf(e -> e.destination == myRouter);
            Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(exits);
            int count = items.getOrDefault(ItemIdentifier.get((ItemStack)wanted), 0);
            if (count == 0 && !craft) {
                return new OpResult(Collections.singletonList(wanted));
            }
            int reqCount = craft ? wanted.func_190916_E() : Math.min(count, wanted.func_190916_E());
            BridgePipe.request(ItemIdentifier.get((ItemStack)wanted).makeStack(reqCount), BridgePipe.this, ll, null);
            OpResult res = ll.asResult();
            if (!craft && wanted.func_190916_E() > count) {
                int missingCount = wanted.func_190916_E() - count;
                ItemStack missingStack = wanted.func_77946_l();
                missingStack.func_190920_e(missingCount);
                res.missing.add(missingStack);
            }
            return res;
        }

        public boolean isDefaultRoute() {
            return BridgePipe.this.isDefaultRoute;
        }

        public boolean detectChanged() {
            if (this.alreadyProcessing || !BridgePipe.this.isEnabled()) {
                return false;
            }
            if (BridgePipe.this.stillNeedReplace()) {
                return false;
            }
            IRouter myRouter = BridgePipe.this.getRouter();
            ArrayList<ExitRoute> exits = new ArrayList<ExitRoute>(myRouter.getIRoutersByCost());
            exits.removeIf(e -> e.destination == myRouter);
            LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(exits);
            if (items.size() != this.craftedStacks.size()) {
                this.craftedStacks.clear();
                this.craftedStacks.addAll(items);
                return true;
            }
            boolean c = this.craftedStacks.containsAll(items);
            if (!c) {
                this.craftedStacks.clear();
                this.craftedStacks.addAll(items);
                return true;
            }
            return false;
        }
    }

    public static class ListLog
    implements RequestLog {
        private final List<IResource> missing = new ArrayList<IResource>();
        private final List<IResource> used = new ArrayList<IResource>();

        private static List<ItemStack> toList(List<IResource> resList) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(resList.size());
            for (IResource e : resList) {
                if (e instanceof ItemResource) {
                    list.add(((ItemResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
                    continue;
                }
                if (!(e instanceof DictResource)) continue;
                list.add(((DictResource)e).getItem().unsafeMakeNormalStack(e.getRequestedAmount()));
            }
            return list;
        }

        public void handleMissingItems(List<IResource> resources) {
            this.missing.addAll(resources);
        }

        public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList paticipating) {
        }

        public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList paticipating) {
            this.used.addAll(resources);
        }

        public List<ItemStack> getMissingItems() {
            return ListLog.toList(this.missing);
        }

        public List<ItemStack> getUsedItems() {
            return ListLog.toList(this.used);
        }

        public OpResult asResult() {
            return new OpResult(this.getUsedItems(), this.getMissingItems());
        }
    }

    public static class OpResult {
        public List<ItemStack> used;
        public List<ItemStack> missing;
        public List<ItemStack> extra = new ArrayList<ItemStack>();

        public OpResult() {
        }

        public OpResult(List<ItemStack> missing) {
            this.missing = missing;
            this.used = Collections.emptyList();
        }

        public OpResult(List<ItemStack> used, List<ItemStack> missing) {
            this.used = used;
            this.missing = missing;
        }
    }
}

