/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.part;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.tom.logisticsbridge.AE2Plugin;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.network.SetIDPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class PartSatelliteBus
extends PartSharedItemBus
implements SetIDPacket.IIdPipe {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("logisticsbridge", "part/satellite_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("logisticsbridge", "part/satellite_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("logisticsbridge", "part/satellite_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("logisticsbridge", "part/satellite_bus_has_channel")});
    public String satelliteId = "";
    private final List<IAEItemStack> itemsToInsert = new ArrayList<IAEItemStack>();

    public PartSatelliteBus(ItemStack is) {
        super(is);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.getMin(), TickRates.ExportBus.getMax(), this.isSleeping(), false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        if (!this.itemsToInsert.isEmpty()) {
            ListIterator<IAEItemStack> itr = this.itemsToInsert.listIterator();
            boolean didSomething = false;
            while (itr.hasNext()) {
                IAEItemStack stack = itr.next();
                if (stack == null) {
                    itr.remove();
                    continue;
                }
                IAEItemStack result = this.injectCraftedItems(stack, Actionable.MODULATE);
                if (!stack.equals(result)) {
                    didSomething = true;
                }
                if (result != null) {
                    itr.set(result);
                    continue;
                }
                itr.remove();
            }
            return didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private IAEItemStack injectCraftedItems(IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler();
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = (double)items.getStackSize(), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (mode == Actionable.MODULATE) {
                    return AEItemStack.fromItemStack((ItemStack)d.addItems(items.createItemStack()));
                }
                return AEItemStack.fromItemStack((ItemStack)d.simulateAdd(items.createItemStack()));
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODELS_HAS_CHANNEL;
            }
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d posIn) {
        if (Platform.isServer()) {
            if (player.func_184586_b(hand).func_77973_b() == LogisticsBridge.packageItem) {
                ItemStack is = player.func_184586_b(hand);
                if (!is.func_77942_o()) {
                    is.func_77982_d(new NBTTagCompound());
                }
                is.func_77978_p().func_74778_a("__pkgDest", this.satelliteId);
                player.field_71069_bz.func_75142_b();
            } else {
                TileEntity tile = this.getHost().getTile();
                BlockPos pos = tile.func_174877_v();
                player.openGui((Object)LogisticsBridge.modInstance, 100 + this.getSide().ordinal(), tile.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.satelliteId).setId(0).setSide(this.getSide().ordinal()).setTilePos(this.getTile());
                MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
            }
        }
        return true;
    }

    @Override
    public String getPipeID(int id) {
        return this.satelliteId;
    }

    @Override
    public void setPipeID(int id, String pipeID, EntityPlayer player) {
        if (player == null) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setSide(this.getSide().ordinal()).setTilePos(this.getTile());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setSide(this.getSide().ordinal()).setTilePos(this.getTile());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        this.satelliteId = pipeID;
    }

    @Override
    public String getName(int id) {
        return "gui.satelliteBus.id";
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74778_a("satName", this.satelliteId);
        NBTTagList lst = new NBTTagList();
        this.itemsToInsert.stream().map(s -> {
            NBTTagCompound tag = new NBTTagCompound();
            s.writeToNBT(tag);
            return tag;
        }).forEach(arg_0 -> ((NBTTagList)lst).func_74742_a(arg_0));
        extra.func_74782_a("itemsToInsert", (NBTBase)lst);
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.satelliteId = extra.func_74779_i("satName");
        NBTTagList lst = extra.func_150295_c("itemsToInsert", 10);
        this.itemsToInsert.clear();
        IItemStorageChannel items = (IItemStorageChannel)AE2Plugin.INSTANCE.api.storage().getStorageChannel(IItemStorageChannel.class);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tag = lst.func_150305_b(i);
            this.itemsToInsert.add((IAEItemStack)items.createFromNBT(tag));
        }
    }

    public boolean push(IInventory table) {
        if (this.itemsToInsert.size() > 9) {
            return false;
        }
        IItemStorageChannel items = (IItemStorageChannel)AE2Plugin.INSTANCE.api.storage().getStorageChannel(IItemStorageChannel.class);
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            ItemStack is = table.func_70304_b(i);
            if (is.func_190926_b()) continue;
            this.itemsToInsert.add((IAEItemStack)items.createStack((Object)is));
        }
        return true;
    }

    public boolean push(ItemStack is) {
        if (this.itemsToInsert.size() > 9) {
            return false;
        }
        IItemStorageChannel items = (IItemStorageChannel)AE2Plugin.INSTANCE.api.storage().getStorageChannel(IItemStorageChannel.class);
        if (!is.func_190926_b()) {
            this.itemsToInsert.add((IAEItemStack)items.createStack((Object)is));
        }
        return true;
    }

    public InventoryAdaptor getHandler() {
        return super.getHandler();
    }
}

