/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.node;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.tom.logisticsbridge.network.SetIDPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class NetworkNodeSatellite
extends NetworkNode
implements SetIDPacket.IIdPipe {
    public static final String ID = "lb.satellite";
    public String satelliteId = "";
    private final List<ItemStack> itemsToInsert = new ArrayList<ItemStack>();

    public NetworkNodeSatellite(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 1;
    }

    public String getId() {
        return ID;
    }

    public void update() {
        IItemHandler h;
        TileEntity te;
        super.update();
        if (!this.world.field_72995_K && (te = this.getFacingTile()) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection()) && (h = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection())) != null && !this.itemsToInsert.isEmpty()) {
            ListIterator<ItemStack> itr = this.itemsToInsert.listIterator();
            while (itr.hasNext()) {
                ItemStack stack = itr.next();
                if (stack == null) {
                    itr.remove();
                    continue;
                }
                ItemStack result = this.injectCraftedItems(stack, h);
                if (result != null) {
                    itr.set(result);
                    continue;
                }
                itr.remove();
            }
        }
    }

    public IItemHandler getHandler() {
        TileEntity te = this.getFacingTile();
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection())) {
            IItemHandler h = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection());
            return h;
        }
        return null;
    }

    private ItemStack injectCraftedItems(ItemStack stack, IItemHandler h) {
        for (int i = 0; i < h.getSlots() && !(stack = h.insertItem(i, stack, false)).func_190926_b(); ++i) {
        }
        return stack;
    }

    public NBTTagCompound write(NBTTagCompound extra) {
        super.write(extra);
        extra.func_74778_a("satName", this.satelliteId);
        NBTTagList lst = new NBTTagList();
        this.itemsToInsert.stream().map(s -> {
            NBTTagCompound tag = new NBTTagCompound();
            s.func_77955_b(tag);
            return tag;
        }).forEach(arg_0 -> ((NBTTagList)lst).func_74742_a(arg_0));
        extra.func_74782_a("itemsToInsert", (NBTBase)lst);
        return extra;
    }

    public void read(NBTTagCompound extra) {
        super.read(extra);
        this.satelliteId = extra.func_74779_i("satName");
        NBTTagList lst = extra.func_150295_c("itemsToInsert", 10);
        this.itemsToInsert.clear();
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            this.itemsToInsert.add(new ItemStack(lst.func_150305_b(i)));
        }
    }

    public void push(ItemStack is) {
        if (!is.func_190926_b()) {
            this.itemsToInsert.add(is);
        }
    }

    @Override
    public String getPipeID(int id) {
        return this.satelliteId;
    }

    @Override
    public void setPipeID(int id, String pipeID, EntityPlayer player) {
        if (player == null) {
            ModernPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setBlockPos(this.getPos()).setDimension(this.getWorld());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            ModernPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setBlockPos(this.getPos()).setDimension(this.getWorld());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        this.satelliteId = pipeID;
    }

    @Override
    public String getName(int id) {
        return "gui.satelliteBus.id";
    }
}

