/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.node;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCrafter;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.item.VirtualPatternRS;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.node.NetworkNodeSatellite;
import com.tom.logisticsbridge.pipe.CraftingManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeCraftingManager
extends NetworkNode
implements SetIDPacket.IIdPipe,
ICraftingPatternContainer {
    public static final String ID = "lb.craftingmngr";
    private static final String NAME = "tile.lb.crafingmanager.rs.name";
    private static final String NBT_UUID = "uuid";
    private String supplyID;
    @Nullable
    private UUID uuid = null;
    private final List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private boolean reading;
    private final ItemHandlerBase patternsInventory = new ItemHandlerBase(27, (Consumer)new ListenerNetworkNode((INetworkNode)this), new Predicate[]{s -> NetworkNodeCrafter.isValidPatternInSlot((World)this.world, (ItemStack)s)}){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeCraftingManager.this.reading) {
                if (!((NetworkNodeCraftingManager)NetworkNodeCraftingManager.this).world.field_72995_K) {
                    NetworkNodeCraftingManager.this.invalidate();
                }
                if (NetworkNodeCraftingManager.this.network != null) {
                    NetworkNodeCraftingManager.this.network.getCraftingManager().rebuild();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private CraftingManager.BlockingMode blockingMode = CraftingManager.BlockingMode.OFF;
    private final IItemHandler inv = new IItemHandler(){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (NetworkNodeCraftingManager.this.supplyID.isEmpty()) {
                return stack;
            }
            if (!NetworkNodeCraftingManager.this.checkBlocking()) {
                return stack;
            }
            NetworkNodeSatellite sat = NetworkNodeCraftingManager.this.find(NetworkNodeCraftingManager.this.supplyID);
            if (sat == null) {
                return stack;
            }
            if (stack.func_77973_b() == LogisticsBridge.packageItem && stack.func_77942_o() && stack.func_77978_p().func_74767_n("__actStack")) {
                String id = stack.func_77978_p().func_74779_i("__pkgDest");
                sat = NetworkNodeCraftingManager.this.find(id);
                if (sat == null) {
                    return stack;
                }
                if (!simulate) {
                    ItemStack pkgItem = new ItemStack(stack.func_77978_p());
                    pkgItem.func_190920_e(pkgItem.func_190916_E() * stack.func_190916_E());
                    sat.push(pkgItem);
                }
            } else if (!simulate) {
                sat.push(stack);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return 9;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };

    public NetworkNodeCraftingManager(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 10;
    }

    public String getId() {
        return ID;
    }

    @Override
    public String getName(int id) {
        return null;
    }

    @Override
    public String getPipeID(int id) {
        return id == 0 ? this.supplyID : Integer.toString(this.blockingMode.ordinal());
    }

    @Override
    public void setPipeID(int id, String pipeID, EntityPlayer player) {
        if (pipeID == null) {
            pipeID = "";
        }
        if (player == null) {
            ModernPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setBlockPos(this.getPos()).setDimension(this.getWorld());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            ModernPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setBlockPos(this.getPos()).setDimension(this.getWorld());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        if (id == 0) {
            this.supplyID = pipeID;
        } else if (id == 1) {
            this.blockingMode = CraftingManager.BlockingMode.values[Math.abs(pipeID.charAt(0) - 48) % CraftingManager.BlockingMode.values.length];
        }
    }

    public NBTTagCompound write(NBTTagCompound compound) {
        compound.func_74778_a("supplyName", this.supplyID);
        if (this.uuid != null) {
            compound.func_186854_a(NBT_UUID, this.uuid);
        }
        StackUtils.writeItems((IItemHandler)this.patternsInventory, (int)0, (NBTTagCompound)compound);
        compound.func_74774_a("blockingMode", (byte)this.blockingMode.ordinal());
        return super.write(compound);
    }

    public void read(NBTTagCompound compound) {
        this.reading = true;
        StackUtils.readItems((IItemHandlerModifiable)this.patternsInventory, (int)0, (NBTTagCompound)compound);
        this.invalidate();
        this.reading = false;
        this.supplyID = compound.func_74779_i("supplyName");
        if (compound.func_186855_b(NBT_UUID)) {
            this.uuid = compound.func_186857_a(NBT_UUID);
        }
        this.blockingMode = CraftingManager.BlockingMode.values[Math.abs(compound.func_74771_c("blockingMode")) % CraftingManager.BlockingMode.values.length];
        super.read(compound);
    }

    @Override
    public List<String> list(int id) {
        return this.network.getNodeGraph().all().stream().filter(n -> n instanceof NetworkNodeSatellite).map(n -> ((NetworkNodeSatellite)n).satelliteId).collect(Collectors.toList());
    }

    private NetworkNodeSatellite find(String id) {
        return this.network.getNodeGraph().all().stream().filter(n -> n instanceof NetworkNodeSatellite).map(n -> (NetworkNodeSatellite)n).filter(n -> id.equals(n.satelliteId)).findFirst().orElse(null);
    }

    public IItemHandler getConnectedInventory() {
        return this.inv;
    }

    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    public String getName() {
        return NAME;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public ICraftingPatternContainer getRootContainer() {
        return this;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public IFluidHandler getConnectedFluidInventory() {
        return null;
    }

    public TileEntity getConnectedTile() {
        return null;
    }

    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    private void invalidate() {
        this.patterns.clear();
        for (int i = 0; i < this.patternsInventory.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patternsInventory.getStackInSlot(i);
            if (patternStack.func_190926_b() || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, (ICraftingPatternContainer)this)).isValid()) continue;
            List inputs = pattern.getInputs();
            boolean pkg = false;
            for (NonNullList nonNullList : inputs) {
                if (nonNullList.size() != 1 || ((ItemStack)nonNullList.get(0)).func_77973_b() != LogisticsBridge.packageItem || !((ItemStack)nonNullList.get(0)).func_77942_o()) continue;
                pkg = true;
                ItemStack is = ((ItemStack)nonNullList.get(0)).func_77946_l();
                is.func_77978_p().func_74757_a("__actStack", true);
                nonNullList.set(0, (Object)is);
                this.patterns.add(VirtualPatternRS.create(new ItemStack(((ItemStack)nonNullList.get(0)).func_77978_p()), is, (ICraftingPatternContainer)this));
            }
            this.patterns.add(pattern);
        }
    }

    protected void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getCraftingManager().rebuild();
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    private boolean checkBlocking() {
        switch (this.blockingMode) {
            case EMPTY_MAIN_SATELLITE: {
                if (this.supplyID.isEmpty()) {
                    return false;
                }
                NetworkNodeSatellite bus = this.find(this.supplyID);
                if (bus == null) {
                    return false;
                }
                IItemHandler invent = bus.getHandler();
                if (invent != null) {
                    for (int i = 0; i < invent.getSlots(); ++i) {
                        ItemStack stackInSlot = invent.getStackInSlot(i);
                        if (stackInSlot.func_190926_b()) continue;
                        return false;
                    }
                }
                return true;
            }
            case REDSTONE_HIGH: {
                return this.getWorld().func_175640_z(this.getPos());
            }
            case REDSTONE_LOW: {
                return !this.getWorld().func_175640_z(this.getPos());
            }
        }
        return true;
    }

    public CraftingManager.BlockingMode getBlockingMode() {
        return this.blockingMode;
    }
}

