/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.module;

import com.tom.logisticsbridge.pipe.CraftingManager;
import com.tom.logisticsbridge.pipe.ResultPipe;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.modules.ChassisModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.DictCraftingTemplate;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleCrafterExt
extends ModuleCrafter {
    public ICraftingTemplate addCrafting(IResource toCraft) {
        int i;
        int i2;
        if (!(this._service instanceof CraftingManager)) {
            return null;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        List stack = this.getCraftedItems();
        if (stack == null) {
            return null;
        }
        ItemCraftingTemplate template = null;
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzy().nextSetBit(0) != -1) {
            for (ItemIdentifierStack craftable : stack) {
                DictResource dict = new DictResource(craftable, null);
                dict.loadFromBitSet(this.outputFuzzy().copyValue());
                if (!toCraft.matches((IResource)dict, IResource.MatchSettings.NORMAL)) continue;
                template = new DictCraftingTemplate(dict, (ICraftItems)this, ((Integer)this.priority.getValue()).intValue());
                break;
            }
        } else {
            for (ItemIdentifierStack craftable : stack) {
                if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL)) continue;
                template = new ItemCraftingTemplate(craftable, (ICraftItems)this, ((Integer)this.priority.getValue()).intValue());
                break;
            }
        }
        if (template == null) {
            return null;
        }
        boolean buffered = mngr.isBuffered();
        IRouter defSat = this.getSatelliteRouterByID(mngr.getSatelliteUUID());
        if (defSat == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        if (buffered) {
            for (i2 = 0; i2 < 9; ++i2) {
                target[i2] = this;
            }
        } else {
            int i3;
            for (i3 = 0; i3 < 9; ++i3) {
                target[i3] = defSat.getPipe();
            }
            if (!this.isSatelliteConnected()) {
                return null;
            }
            if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
                IRouter r = this.getSatelliteRouter(-1);
                if (r != null) {
                    CoreRoutedPipe sat = r.getPipe();
                    for (i = 6; i < 9; ++i) {
                        target[i] = sat;
                    }
                }
            } else {
                for (i3 = 0; i3 < 9; ++i3) {
                    IRouter r = this.getSatelliteRouter(i3);
                    if (r == null) continue;
                    target[i3] = r.getPipe();
                }
            }
        }
        for (i2 = 0; i2 < 9; ++i2) {
            ItemResource req;
            ItemIdentifierStack resourceStack = this.dummyInventory.getIDStackInSlot(i2);
            if (resourceStack == null || resourceStack.getStackSize() == 0) continue;
            if (this.getUpgradeManager().isFuzzyUpgrade() && this.inputFuzzy(i2).nextSetBit(0) != -1) {
                DictResource dict = new DictResource(resourceStack, target[i2]);
                req = dict;
                dict.loadFromBitSet(this.inputFuzzy(i2).copyValue());
            } else {
                req = new ItemResource(resourceStack, target[i2]);
            }
            template.addRequirement((IResource)req, (IAdditionalTargetInformation)new ModuleCrafter.CraftingChassisInformation(i2, this.getPositionInt()));
        }
        int liquidCrafter = this.getUpgradeManager().getFluidCrafter();
        IRequestFluid[] liquidTarget = new IRequestFluid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r = this.getFluidSatelliteRouter(-1);
            if (r != null) {
                IRequestFluid sat = (IRequestFluid)r.getPipe();
                for (int i4 = 0; i4 < liquidCrafter; ++i4) {
                    liquidTarget[i4] = sat;
                }
            }
        } else {
            for (i = 0; i < liquidCrafter; ++i) {
                IRouter r = this.getFluidSatelliteRouter(i);
                if (r == null) continue;
                liquidTarget[i] = (IRequestFluid)r.getPipe();
            }
        }
        for (int i5 = 0; i5 < liquidCrafter; ++i5) {
            FluidIdentifier liquid = this.getFluidMaterial(i5);
            int amount = (Integer)this.liquidAmounts.get(i5);
            if (liquid == null || amount <= 0 || liquidTarget[i5] == null) continue;
            template.addRequirement((IResource)new FluidResource(liquid, amount, liquidTarget[i5]), null);
        }
        if (this.getUpgradeManager().hasByproductExtractor() && this.getByproductItem() != null) {
            template.addByproduct(this.getByproductItem());
        }
        return template;
    }

    private IRouter getSatelliteRouter(int x) {
        UUID satelliteUUID = x == -1 ? (UUID)this.satelliteUUID.getValue() : (UUID)this.advancedSatelliteUUIDList.get(x);
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(satelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    private IRouter getFluidSatelliteRouter(int x) {
        UUID liquidSatelliteUUID = x == -1 ? (UUID)this.liquidSatelliteUUID.getValue() : (UUID)this.liquidSatelliteUUIDList.get(x);
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(liquidSatelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public IRouter getSatelliteRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public IRouter getResultRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int resultRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(resultRouterId);
    }

    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this._service.getItemOrderManager().hasExtras() || tree.hasBeenQueried((LogisticsOrderManager)this._service.getItemOrderManager())) {
            return;
        }
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        IRouter resultR = this.getResultRouterByID(mngr.getResultUUID());
        if (resultR == null) {
            return;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return;
        }
        IResource requestedItem = tree.getRequestType();
        if (!this.canCraft(requestedItem)) {
            return;
        }
        for (IFilter iFilter : filters) {
            if (iFilter.isBlocked() != iFilter.isFilteredItem(requestedItem) && !iFilter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (LogisticsItemOrder extra : this._service.getItemOrderManager()) {
            if (extra.getType() != IOrderInfoProvider.ResourceType.EXTRA || !extra.getResource().getItem().equals(requestedItem.getAsItem())) continue;
            remaining += extra.getResource().stack.getStackSize();
        }
        ItemIdentifierStack itemIdentifierStack = this.getCraftedItem();
        if (itemIdentifierStack == null) {
            return;
        }
        if ((remaining -= root.getAllPromissesFor((IProvide)this, itemIdentifierStack.getItem())) < 1) {
            return;
        }
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzy().nextSetBit(0) != -1) {
            DictResource dict = new DictResource(itemIdentifierStack, null).loadFromBitSet(this.outputFuzzy().copyValue());
            LogisticsExtraDictPromise promise = new LogisticsExtraDictPromise(dict, Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise((IPromise)promise);
        } else {
            LogisticsExtraPromise promise = new LogisticsExtraPromise(itemIdentifierStack.getItem(), Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise((IPromise)promise);
        }
        tree.setQueried((LogisticsOrderManager)this._service.getItemOrderManager());
    }

    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        IRouter resultR;
        if (!(this._service instanceof CraftingManager)) {
            return null;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        ItemIdentifierStack result = this.getCraftedItem();
        if (result == null) {
            return null;
        }
        int multiply = (int)Math.ceil((float)promise.numberOfItems / (float)result.getStackSize());
        if (mngr.isBuffered()) {
            int i;
            ArrayList<Pair<UUID, ItemIdentifierStack>> rec = new ArrayList<Pair<UUID, ItemIdentifierStack>>();
            UUID defSat = mngr.getSatelliteUUID();
            if (defSat == null) {
                return null;
            }
            UUID[] target = new UUID[9];
            for (int i2 = 0; i2 < 9; ++i2) {
                target[i2] = defSat;
            }
            boolean hasSatellite = this.isSatelliteConnected();
            if (!hasSatellite) {
                return null;
            }
            if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
                for (i = 6; i < 9; ++i) {
                    target[i] = (UUID)this.satelliteUUID.getValue();
                }
            } else {
                for (i = 0; i < 9; ++i) {
                    target[i] = (UUID)this.advancedSatelliteUUIDList.get(i);
                }
            }
            for (i = 0; i < target.length; ++i) {
                ItemIdentifierStack mat = this.dummyInventory.getIDStackInSlot(i);
                if (mat == null) continue;
                rec.add((Pair<UUID, ItemIdentifierStack>)Pair.of((Object)target[i], (Object)mat));
            }
            for (i = 0; i < multiply; ++i) {
                mngr.addBuffered(rec);
            }
        }
        if ((resultR = this.getResultRouterByID(mngr.getResultUUID())) == null) {
            return null;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return null;
        }
        ResultPipe res = (ResultPipe)coreRoutedPipe;
        return res.fullFill(promise, destination, info);
    }

    public boolean openAttachedGui(EntityPlayer player) {
        return false;
    }

    public void registerExtras(IPromise promise) {
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        IRouter resultR = this.getResultRouterByID(mngr.getResultUUID());
        if (resultR == null) {
            return;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return;
        }
        ResultPipe res = (ResultPipe)coreRoutedPipe;
        res.registerExtras(promise);
    }

    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this._service.isNthTick(6)) {
            return;
        }
        if (this._service instanceof CraftingManager && !this._service.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA}) && this.getUpgradeManager().getCrafterCleanup() > 0) {
            IRouter resultR = this.getResultRouterByID(((CraftingManager)this._service).getResultUUID());
            if (resultR == null) {
                return;
            }
            CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
            if (!(coreRoutedPipe instanceof ResultPipe)) {
                return;
            }
            ResultPipe res = (ResultPipe)coreRoutedPipe;
            res.extractCleanup(this.cleanupInventory, (Boolean)this.cleanupModeIsExclude.getValue(), this.getUpgradeManager().getCrafterCleanup() * 3);
        }
    }

    public void guiClosedByPlayer(EntityPlayer player) {
        super.guiClosedByPlayer(player);
        if (!MainProxy.isClient((IBlockAccess)this._world.getWorld()) && this._service instanceof CraftingManager) {
            ChassisModule m = ((CraftingManager)this._service).getModules();
            for (int i = 0; i < 27; ++i) {
                if (m.getModule(i) != this) continue;
                ((CraftingManager)this._service).save(i);
                break;
            }
        }
    }
}

