/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.api;

import appeng.api.storage.data.IAEItemStack;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public interface IDynamicPatternDetailsAE {
    public static final Map<String, Function<NBTTagCompound, IDynamicPatternDetailsAE>> FACTORIES = new HashMap<String, Function<NBTTagCompound, IDynamicPatternDetailsAE>>();
    public static final WeakHashMap<NBTTagCompound, IDynamicPatternDetailsAE> CACHE = new WeakHashMap();
    public static final String ID_TAG = "_id";

    public static IDynamicPatternDetailsAE load(NBTTagCompound tag) {
        return CACHE.computeIfAbsent(tag, t -> {
            String id = t.func_74779_i(ID_TAG);
            Function<NBTTagCompound, IDynamicPatternDetailsAE> fac = FACTORIES.get(id);
            return fac.apply((NBTTagCompound)t);
        });
    }

    public static NBTTagCompound save(IDynamicPatternDetailsAE det) {
        String id = det.getId();
        NBTTagCompound tag = new NBTTagCompound();
        det.storeToNBT(tag);
        tag.func_74778_a(ID_TAG, id);
        return tag;
    }

    default public String getId() {
        throw new AbstractMethodError("Missing impl: " + this.getClass());
    }

    default public void storeToNBT(NBTTagCompound tag) {
        throw new AbstractMethodError("Missing impl: " + this.getClass());
    }

    public IAEItemStack[] getInputs(ItemStack var1, IAEItemStack[] var2, boolean var3);

    public IAEItemStack[] getOutputs(ItemStack var1, IAEItemStack[] var2, boolean var3);

    public static class TileEntityWrapper
    implements IDynamicPatternDetailsAE {
        private final int dim;
        private final BlockPos pos;
        private IDynamicPatternDetailsAE tile;

        public TileEntityWrapper(int dim, BlockPos pos) {
            this.dim = dim;
            this.pos = pos;
        }

        public TileEntityWrapper(TileEntity te) {
            this(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v());
            this.tile = (IDynamicPatternDetailsAE)te;
        }

        public static TileEntityWrapper create(NBTTagCompound tag) {
            return new TileEntityWrapper(tag.func_74762_e("dim"), new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }

        @Override
        public String getId() {
            return "te";
        }

        @Override
        public void storeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("dim", this.dim);
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
        }

        public void load() {
            TileEntity te;
            WorldServer w;
            if (this.tile == null && (w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim)) != null && (te = w.func_175625_s(this.pos)) instanceof IDynamicPatternDetailsAE) {
                this.tile = (IDynamicPatternDetailsAE)te;
            }
        }

        @Override
        public IAEItemStack[] getInputs(ItemStack res, IAEItemStack[] def, boolean condensed) {
            this.load();
            return this.tile != null ? this.tile.getInputs(res, def, condensed) : def;
        }

        @Override
        public IAEItemStack[] getOutputs(ItemStack res, IAEItemStack[] def, boolean condensed) {
            this.load();
            return this.tile != null ? this.tile.getOutputs(res, def, condensed) : def;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dim;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TileEntityWrapper other = (TileEntityWrapper)obj;
            if (this.dim != other.dim) {
                return false;
            }
            if (this.pos == null) {
                return other.pos == null;
            }
            return this.pos.equals((Object)other.pos);
        }
    }
}

