/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.RSAPIInject;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewItem;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.block.BlockBridgeRS;
import com.tom.logisticsbridge.block.BlockCraftingManagerRS;
import com.tom.logisticsbridge.block.BlockSatelliteBus;
import com.tom.logisticsbridge.item.VirtualPatternRS;
import com.tom.logisticsbridge.node.NetworkNodeBridge;
import com.tom.logisticsbridge.node.NetworkNodeCraftingManager;
import com.tom.logisticsbridge.node.NetworkNodeSatellite;
import com.tom.logisticsbridge.tileentity.TileEntityBridgeRS;
import com.tom.logisticsbridge.tileentity.TileEntityCraftingManagerRS;
import com.tom.logisticsbridge.tileentity.TileEntitySatelliteBus;
import java.util.List;
import java.util.function.BiFunction;
import logisticspipes.LPItems;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RSPlugin {
    @RSAPIInject
    public static IRSAPI rsapi;
    public static VirtualPatternRS virtualPattern;
    public static BlockBase satelliteBus;
    public static BlockBase craftingManager;

    public static void preInit() {
        virtualPattern = new VirtualPatternRS();
        satelliteBus = new BlockSatelliteBus();
        craftingManager = new BlockCraftingManagerRS();
        LogisticsBridge.bridgeRS = new BlockBridgeRS().func_149663_c("lb.bridge.rs");
        RSPlugin.registerBlock((BlockBase)LogisticsBridge.bridgeRS);
        RSPlugin.registerBlock(satelliteBus);
        RSPlugin.registerBlock(craftingManager);
        LogisticsBridge.registerItem(virtualPattern, true);
        GameRegistry.registerTileEntity(TileEntityBridgeRS.class, (ResourceLocation)new ResourceLocation("logisticsbridge", "bridge_rs"));
        GameRegistry.registerTileEntity(TileEntitySatelliteBus.class, (ResourceLocation)new ResourceLocation("logisticsbridge", "satellite_bus_rs"));
        GameRegistry.registerTileEntity(TileEntityCraftingManagerRS.class, (ResourceLocation)new ResourceLocation("logisticsbridge", "craftingmanager_rs"));
        RSPlugin.registerNode("lb.bridge", NetworkNodeBridge::new);
        RSPlugin.registerNode("lb.satellite", NetworkNodeSatellite::new);
        RSPlugin.registerNode("lb.craftingmngr", NetworkNodeCraftingManager::new);
    }

    private static void registerNode(String id, BiFunction<World, BlockPos, NetworkNode> constr) {
        API.instance().getNetworkNodeRegistry().add(id, (tag, world, pos) -> {
            NetworkNode node = (NetworkNode)constr.apply(world, pos);
            node.read(tag);
            return node;
        });
    }

    private static void registerBlock(BlockBase block) {
        LogisticsBridge.registerBlock(block, BlockBase::createItem);
    }

    public static void loadRecipes(ResourceLocation group) {
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(LogisticsBridge.bridgeRS), new Object[]{"iei", "bIb", "ici", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), LPItems.pipeBasic, Character.valueOf('I'), RSBlocks.INTERFACE, Character.valueOf('c'), new ItemStack((Item)RSItems.PROCESSOR, 1, 4), Character.valueOf('e'), new ItemStack((Item)RSItems.PROCESSOR, 1, 5)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/bridge_rs")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack((Block)satelliteBus), new Object[]{"ii ", "Ic-", "ii ", Character.valueOf('i'), "ingotIron", Character.valueOf('-'), RSBlocks.CABLE, Character.valueOf('I'), new ItemStack((Item)RSItems.CORE, 1, 0), Character.valueOf('c'), new ItemStack((Item)RSItems.PROCESSOR, 1, 4)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/satellite_bus_rs")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack((Block)craftingManager), new Object[]{"cIc", "bab", "iIi", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), RSBlocks.CRAFTER, Character.valueOf('b'), new ItemStack((Item)RSItems.PROCESSOR, 1, 3), Character.valueOf('I'), new ItemStack((Item)RSItems.PROCESSOR, 1, 4), Character.valueOf('a'), new ItemStack((Item)RSItems.PROCESSOR, 1, 5)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/crafting_manager_rs")));
    }

    @SideOnly(value=Side.CLIENT)
    public static void hideFakeItems(GuiScreenEvent.BackgroundDrawnEvent event) {
        IGridView view;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiGrid && !GuiScreen.func_146271_m() && (view = ((GuiGrid)mc.field_71462_r).getView()) instanceof GridViewItem) {
            List stacks = view.getStacks();
            stacks.removeIf(s -> {
                Object ing = s.getIngredient();
                if (ing instanceof ItemStack) {
                    ItemStack is = (ItemStack)ing;
                    return is.func_77973_b() == LogisticsBridge.logisticsFakeItem || is.func_77973_b() == LogisticsBridge.packageItem && s.getQuantity() == 0;
                }
                return false;
            });
        }
    }
}

