/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge;

import com.tom.logisticsbridge.AE2Plugin;
import com.tom.logisticsbridge.GuiHandler;
import com.tom.logisticsbridge.RSPlugin;
import com.tom.logisticsbridge.block.BlockClassLoader;
import com.tom.logisticsbridge.inventory.ContainerCraftingManager;
import com.tom.logisticsbridge.item.FakeItem;
import com.tom.logisticsbridge.module.AdvItemExtractionUpgrade;
import com.tom.logisticsbridge.module.BufferUpgrade;
import com.tom.logisticsbridge.module.CraftingManagerPipeSign;
import com.tom.logisticsbridge.network.RequestIDListPacket;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.pipe.BridgePipe;
import com.tom.logisticsbridge.pipe.CraftingManager;
import com.tom.logisticsbridge.pipe.ResultPipe;
import com.tom.logisticsbridge.proxy.CommonProxy;
import com.tom.logisticsbridge.util.DynamicInventory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.items.ItemPipeSignCreator;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.upgrades.ItemStackExtractionUpgrade;
import logisticspipes.recipes.NBTIngredient;
import logisticspipes.textures.Textures;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.ModuleSlot;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="logisticsbridge", name="Logistics Bridge", version="1.4.5.4", dependencies="after:appliedenergistics2;after:refinedstorage@[1.6.15,);required-after:logisticspipes@[0.10.3.84,)", updateJSON="https://raw.githubusercontent.com/Domaman202/LogisticsBridge/master/version-check.json")
public class LogisticsBridge {
    public static final String ID = "logisticsbridge";
    public static final String NAME = "Logistics Bridge";
    public static final String VERSION = "1.4.5.4";
    public static final String DEPS = "after:appliedenergistics2;after:refinedstorage@[1.6.15,);required-after:logisticspipes@[0.10.3.84,)";
    public static final String UPDATE = "https://raw.githubusercontent.com/Domaman202/LogisticsBridge/master/version-check.json";
    public static final Logger log = LogManager.getLogger((String)"Logistics Bridge");
    private static final String CLIENT_PROXY_CLASS = "com.tom.logisticsbridge.proxy.ClientProxy";
    private static final String SERVER_PROXY_CLASS = "com.tom.logisticsbridge.proxy.ServerProxy";
    private static Method registerTexture;
    private static Method registerPipe;
    @SidedProxy(clientSide="com.tom.logisticsbridge.proxy.ClientProxy", serverSide="com.tom.logisticsbridge.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static Block bridgeAE;
    public static Block bridgeRS;
    public static Block craftingManager;
    public static Item logisticsFakeItem;
    public static Item packageItem;
    public static boolean aeLoaded;
    public static boolean rsLoaded;
    @GameRegistry.ObjectHolder(value="logisticspipes:pipe_lb.bridgepipe")
    public static Item pipeBridge;
    @GameRegistry.ObjectHolder(value="logisticspipes:pipe_lb.resultpipe")
    public static Item pipeResult;
    @GameRegistry.ObjectHolder(value="logisticspipes:pipe_lb.craftingmanager")
    public static Item pipeCraftingManager;
    @GameRegistry.ObjectHolder(value="logisticspipes:upgrade_lb.buffer_upgrade")
    public static Item upgradeBuffer;
    @GameRegistry.ObjectHolder(value="logisticspipes:upgrade_lb.adv_extraction_upgrade")
    public static Item upgradeAdvExt;
    @Mod.Instance(value="logisticsbridge")
    public static LogisticsBridge modInstance;

    @Mod.EventHandler
    public static void construction(FMLConstructionEvent evt) {
        log.info("Logistics Bridge version: 1.4.5.4");
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) throws Exception {
        log.info("Start Pre Initialization");
        long tM = System.currentTimeMillis();
        aeLoaded = Loader.isModLoaded((String)"appliedenergistics2");
        rsLoaded = Loader.isModLoaded((String)"refinedstorage");
        logisticsFakeItem = new FakeItem(false).func_77655_b("lb.logisticsFakeItem");
        packageItem = new FakeItem(true).func_77655_b("lb.package").func_77637_a(CreativeTabs.field_78026_f);
        if (aeLoaded) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            BlockClassLoader newLoader = new BlockClassLoader(loader);
            thread.setContextClassLoader((ClassLoader)((Object)newLoader));
            Class<?> clazz = ((ClassLoader)((Object)newLoader)).loadClass("com.tom.logisticsbridge.AE2Plugin");
            clazz.getMethod("preInit", ClassLoader.class).invoke(null, new Object[]{newLoader});
            thread.setContextClassLoader(loader);
        }
        if (rsLoaded) {
            RSPlugin.preInit();
        }
        LogisticsBridge.registerItem(logisticsFakeItem, true);
        LogisticsBridge.registerItem(packageItem, true);
        try {
            registerTexture = Textures.class.getDeclaredMethod("registerTexture", Object.class, String.class, Integer.TYPE);
            registerTexture.setAccessible(true);
            registerPipe = LogisticsPipes.class.getDeclaredMethod("registerPipe", IForgeRegistry.class, String.class, Function.class);
            registerPipe.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        MinecraftForge.EVENT_BUS.register((Object)modInstance);
        proxy.registerRenderers();
        log.info("Pre Initialization took in {0} milliseconds", (Object)(System.currentTimeMillis() - tM));
    }

    private static void registerPipe(IForgeRegistry<Item> registry, String name, Function<Item, ? extends CoreUnroutedPipe> constructor) {
        try {
            registerPipe.invoke((Object)LogisticsPipes.instance, registry, name, constructor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        log.info("Start Initialization");
        long tM = System.currentTimeMillis();
        if (evt.getSide() == Side.SERVER) {
            LogisticsBridge.registerTextures(null);
        }
        if (aeLoaded) {
            AE2Plugin.patchSorter();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)modInstance, (IGuiHandler)new GuiHandler());
        proxy.init();
        LogisticsBridge.loadRecipes();
        log.info("Initialization took in {0} milliseconds", (Object)(System.currentTimeMillis() - tM));
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        log.info("Start Post Initialization");
        long tM = System.currentTimeMillis();
        ItemPipeSignCreator.signTypes.add(CraftingManagerPipeSign.class);
        log.info("Post Initialization took in {0} milliseconds", (Object)(System.currentTimeMillis() - tM));
    }

    private static void loadRecipes() {
        ResourceLocation bridgePrg = LogisticsBridge.pipeBridge.delegate.name();
        ResourceLocation resultPrg = LogisticsBridge.pipeResult.delegate.name();
        ResourceLocation craftingMgrPrg = LogisticsBridge.pipeCraftingManager.delegate.name();
        ResourceLocation bufferUpgr = LogisticsBridge.upgradeBuffer.delegate.name();
        ((Set)LogisticsProgramCompilerTileEntity.programByCategory.get(LogisticsProgramCompilerTileEntity.ProgrammCategories.MODDED)).add(bridgePrg);
        ((Set)LogisticsProgramCompilerTileEntity.programByCategory.get(LogisticsProgramCompilerTileEntity.ProgrammCategories.MODDED)).add(resultPrg);
        ((Set)LogisticsProgramCompilerTileEntity.programByCategory.get(LogisticsProgramCompilerTileEntity.ProgrammCategories.MODDED)).add(craftingMgrPrg);
        ((Set)LogisticsProgramCompilerTileEntity.programByCategory.get(LogisticsProgramCompilerTileEntity.ProgrammCategories.MODDED)).add(bufferUpgr);
        ResourceLocation group = new ResourceLocation(ID, "recipes");
        if (aeLoaded) {
            AE2Plugin.loadRecipes(group);
        }
        if (rsLoaded) {
            RSPlugin.loadRecipes(group);
        }
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(pipeBridge), new Object[]{" p ", "fbf", "dad", Character.valueOf('p'), LogisticsBridge.getIngredientForProgrammer(bridgePrg), Character.valueOf('b'), LPItems.pipeBasic, Character.valueOf('f'), LPItems.chipFPGA, Character.valueOf('d'), "gemDiamond", Character.valueOf('a'), LPItems.chipAdvanced}).setRegistryName(new ResourceLocation(ID, "recipes/pipe_bridge")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(pipeResult), new Object[]{" p ", "rar", " s ", Character.valueOf('p'), LogisticsBridge.getIngredientForProgrammer(resultPrg), Character.valueOf('s'), LPItems.pipeBasic, Character.valueOf('a'), LPItems.chipFPGA, Character.valueOf('r'), "dustRedstone"}).setRegistryName(new ResourceLocation(ID, "recipes/pipe_result")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(pipeCraftingManager), new Object[]{"gpg", "rsr", "gcg", Character.valueOf('p'), LogisticsBridge.getIngredientForProgrammer(craftingMgrPrg), Character.valueOf('s'), LPItems.pipeBasic, Character.valueOf('g'), LPItems.chipFPGA, Character.valueOf('r'), "ingotGold", Character.valueOf('c'), "chest"}).setRegistryName(new ResourceLocation(ID, "recipes/crafting_manager")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(packageItem), new Object[]{"pw", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('w'), "plankWood"}).setRegistryName(new ResourceLocation(ID, "recipes/package")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(upgradeBuffer), new Object[]{"rpr", "ici", "PnP", Character.valueOf('p'), LogisticsBridge.getIngredientForProgrammer(bufferUpgr), Character.valueOf('n'), LPItems.chipAdvanced, Character.valueOf('c'), LPItems.chipFPGA, Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "gemDiamond", Character.valueOf('P'), "paper"}).setRegistryName(new ResourceLocation(ID, "recipes/buffer_upgrade")));
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(group, new ItemStack(upgradeAdvExt), new Object[]{ItemUpgrade.getAndCheckUpgrade((ResourceLocation)((ResourceLocation)LPItems.upgrades.get((Object)ItemStackExtractionUpgrade.getName()))), "dustRedstone"}).setRegistryName(new ResourceLocation(ID, "recipes/adv_ext_upgrade")));
    }

    private static Ingredient getIngredientForProgrammer(ResourceLocation rl) {
        ItemStack programmerStack = new ItemStack((Item)LPItems.logisticsProgrammer);
        programmerStack.func_77982_d(new NBTTagCompound());
        programmerStack.func_77978_p().func_74778_a("LogisticsRecipeTarget", rl.toString());
        return NBTIngredient.func_193369_a((ItemStack[])new ItemStack[]{programmerStack});
    }

    public static void registerTextures(Object object) {
        BridgePipe.TEXTURE = LogisticsBridge.registerTexture(object, "pipes/lb/bridge");
        ResultPipe.texture = LogisticsBridge.registerTexture(object, "pipes/lb/result");
        CraftingManager.texture = LogisticsBridge.registerTexture(object, "pipes/lb/crafting_manager");
    }

    private static Textures.TextureType registerTexture(Object par1IIconRegister, String fileName) {
        return LogisticsBridge.registerTexture(par1IIconRegister, fileName, 1);
    }

    private static Textures.TextureType registerTexture(Object reg, String fileName, int flag) {
        try {
            return (Textures.TextureType)registerTexture.invoke((Object)LogisticsPipes.textures, reg, fileName, flag);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerItem(Item item, boolean registerRenderer) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(item.func_77658_a().substring(5));
        }
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        if (registerRenderer) {
            proxy.addRenderer(item);
        }
    }

    public static <T extends Block> void registerBlock(T block, Function<T, Item> itemBlock) {
        LogisticsBridge.registerOnlyBlock(block);
        LogisticsBridge.registerItem(itemBlock.apply(block), true);
    }

    public static void registerOnlyBlock(Block block) {
        if (block.getRegistryName() == null) {
            block.setRegistryName(block.func_149739_a().substring(5));
        }
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public static ItemStack fakeStack(int count) {
        return new ItemStack(logisticsFakeItem, count);
    }

    public static ItemStack fakeStack(ItemStack stack, int count) {
        ItemStack is = new ItemStack(logisticsFakeItem, count);
        if (stack != null && !stack.func_190926_b()) {
            is.func_77982_d(stack.func_77955_b(new NBTTagCompound()));
        }
        return is;
    }

    public static ItemStack fakeStack(NBTTagCompound stack, int count) {
        ItemStack is = new ItemStack(logisticsFakeItem, count);
        if (stack != null && !stack.func_82582_d()) {
            is.func_77982_d(stack);
        }
        return is;
    }

    public static ItemStack packageStack(ItemStack stack, int count, String id, boolean actStack) {
        ItemStack is = new ItemStack(packageItem, count);
        if (stack != null && !stack.func_190926_b()) {
            is.func_77982_d(stack.func_77955_b(new NBTTagCompound()));
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74778_a("__pkgDest", id);
        is.func_77978_p().func_74757_a("__actStack", actStack);
        return is;
    }

    public static NBTTagList saveAllItems(IInventory inv) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static void loadAllItems(NBTTagList nbttaglist, IInventory inv) {
        inv.func_174888_l();
        int invSize = inv instanceof DynamicInventory ? Integer.MAX_VALUE : inv.func_70302_i_();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= invSize) continue;
            inv.func_70299_a(j, new ItemStack(nbttagcompound));
        }
    }

    public static void processResIDMod(EntityPlayer player, SetIDPacket pck) {
        if (pck.side == -1) {
            if (player.field_71070_bA instanceof Consumer) {
                ((Consumer)player.field_71070_bA).accept(pck.pid);
            }
        } else if (aeLoaded) {
            AE2Plugin.processResIDMod(player, pck);
        }
    }

    public static SetIDPacket.IIdPipe processReqIDList(EntityPlayer player, RequestIDListPacket pck) {
        if (aeLoaded) {
            return AE2Plugin.processReqIDList(player, pck);
        }
        return null;
    }

    public static <T> Stream<T> concatStreams(Stream<T> ... streams) {
        return Arrays.stream(streams).flatMap(UnaryOperator.identity());
    }

    @SubscribeEvent
    public void initItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        LogisticsBridge.registerPipe((IForgeRegistry<Item>)registry, "lb.bridgepipe", BridgePipe::new);
        LogisticsBridge.registerPipe((IForgeRegistry<Item>)registry, "lb.resultpipe", ResultPipe::new);
        LogisticsBridge.registerPipe((IForgeRegistry<Item>)registry, "lb.craftingmanager", CraftingManager::new);
        ItemUpgrade.registerUpgrade((IForgeRegistry)registry, (String)"lb.buffer_upgrade", BufferUpgrade::new);
        ItemUpgrade.registerUpgrade((IForgeRegistry)registry, (String)"lb.adv_extraction_upgrade", AdvItemExtractionUpgrade::new);
        log.info("Registered Pipes");
    }

    @SubscribeEvent
    public void openGui(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof DummyContainer && !(event.getContainer() instanceof ContainerCraftingManager)) {
            DummyContainer dc = (DummyContainer)event.getContainer();
            dc.field_75151_b.stream().filter(ModuleSlot.class::isInstance).findFirst().map(s -> ((ModuleSlot)s).get_pipe()).filter(CraftingManager.class::isInstance).ifPresent(cmgr -> ((CraftingManager)cmgr).openGui(event.getEntityPlayer()));
        }
    }

    @Mod.EventHandler
    public void cleanup(FMLServerStoppingEvent event) {
        ResultPipe.cleanup();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureLoad(TextureStitchEvent.Pre event) {
        if (!event.getMap().getBasePath().equals("textures")) {
            return;
        }
        proxy.registerTextures();
    }
}

