/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge;

import appeng.api.AEPlugin;
import appeng.api.IAppEngApi;
import appeng.api.config.FuzzyMode;
import appeng.api.definitions.IMaterials;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseItemBlock;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.me.ItemRepo;
import appeng.core.Api;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.IStackSrc;
import appeng.core.features.ItemStackSrc;
import appeng.integration.IntegrationType;
import appeng.items.parts.ItemPart;
import appeng.items.parts.PartType;
import appeng.tile.AEBaseTile;
import appeng.util.ItemSorters;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.MergedPriorityList;
import com.tom.logisticsbridge.HideFakeItem;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.item.VirtualPatternAE;
import com.tom.logisticsbridge.network.RequestIDListPacket;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.part.PartSatelliteBus;
import com.tom.logisticsbridge.proxy.ClientProxy;
import com.tom.logisticsbridge.tileentity.TileEntityBridgeAE;
import com.tom.logisticsbridge.tileentity.TileEntityCraftingManager;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import logisticspipes.LPItems;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

@AEPlugin
public class AE2Plugin {
    public static AE2Plugin INSTANCE;
    public static VirtualPatternAE virtualPattern;
    public static HideFakeItem HIDE_FAKE_ITEM;
    public static Field MergedPriorityList_negative;
    public static PartType SATELLITE_BUS;
    public static ItemStackSrc SATELLITE_BUS_SRC;
    public final IAppEngApi api;

    public AE2Plugin(IAppEngApi api) {
        this.api = api;
        INSTANCE = this;
    }

    public static void registerBlock(Block block) {
        block.func_149647_a((CreativeTabs)CreativeTab.instance);
        LogisticsBridge.registerBlock(block, AEBaseItemBlock::new);
    }

    public static void preInit(ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        virtualPattern = new VirtualPatternAE();
        LogisticsBridge.bridgeAE = ((Block)loader.loadClass("com.tom.logisticsbridge.block.BlockBridgeAE").newInstance()).func_149663_c("lb.bridge");
        LogisticsBridge.craftingManager = ((Block)loader.loadClass("com.tom.logisticsbridge.block.BlockCraftingManager").newInstance()).func_149663_c("lb.crafting_managerAE");
        AE2Plugin.registerBlock(LogisticsBridge.bridgeAE);
        AE2Plugin.registerBlock(LogisticsBridge.craftingManager);
        LogisticsBridge.registerItem(virtualPattern, true);
        try {
            MergedPriorityList_negative = MergedPriorityList.class.getDeclaredField("negative");
            MergedPriorityList_negative.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        SATELLITE_BUS = (PartType)EnumHelper.addEnum(PartType.class, (String)"SATELLITE_BUS", (Class[])new Class[]{Integer.TYPE, String.class, Set.class, Set.class, Class.class}, (Object[])new Object[]{1024, "satellite_bus", EnumSet.of(AEFeature.CRAFTING_CPU), EnumSet.noneOf(IntegrationType.class), PartSatelliteBus.class});
        Api.INSTANCE.getPartModels().registerModels((Collection)SATELLITE_BUS.getModels());
        SATELLITE_BUS_SRC = ItemPart.instance.createPart(SATELLITE_BUS);
        GameRegistry.registerTileEntity(TileEntityBridgeAE.class, (ResourceLocation)new ResourceLocation("logisticsbridge", "bridge"));
        AEBaseTile.registerTileItem(TileEntityBridgeAE.class, (IStackSrc)new BlockStackSrc(LogisticsBridge.bridgeAE, 0, ActivityState.Enabled));
        GameRegistry.registerTileEntity(TileEntityCraftingManager.class, (ResourceLocation)new ResourceLocation("logisticsbridge", "craftingManagerAE"));
        AEBaseTile.registerTileItem(TileEntityCraftingManager.class, (IStackSrc)new BlockStackSrc(LogisticsBridge.craftingManager, 0, ActivityState.Enabled));
    }

    public static void patchSorter() {
        try {
            Field sorterBySize = ItemSorters.class.getDeclaredField("CONFIG_BASED_SORT_BY_SIZE");
            sorterBySize.setAccessible(true);
            Field mod = Field.class.getDeclaredField("modifiers");
            mod.setAccessible(true);
            mod.set(sorterBySize, sorterBySize.getModifiers() & 0xFFFFFFEF);
            final Comparator old = (Comparator)sorterBySize.get(null);
            final IAEItemStack s1 = new StackSize().setStackSize(1L);
            final IAEItemStack s2 = new StackSize().setStackSize(2L);
            sorterBySize.set(null, new Comparator<IAEItemStack>(){

                @Override
                public int compare(IAEItemStack o1, IAEItemStack o2) {
                    int cmp = Long.compare(o2.getStackSize() + o2.getCountRequestable(), o1.getStackSize() + o1.getCountRequestable());
                    return this.applyDirection(cmp);
                }

                private int applyDirection(int cmp) {
                    int dir = old.compare(s1, s2);
                    return dir * cmp;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipes(ResourceLocation group) {
        IMaterials mat = AE2Plugin.INSTANCE.api.definitions().materials();
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(LogisticsBridge.bridgeAE), new Object[]{"iei", "bIb", "ici", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), LPItems.pipeBasic, Character.valueOf('I'), AE2Plugin.INSTANCE.api.definitions().blocks().iface().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('c'), mat.calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('e'), mat.engProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/bridge")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, SATELLITE_BUS_SRC.stack(1), new Object[]{" c ", "ifi", " p ", Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('f'), mat.formationCore().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('i'), "ingotIron", Character.valueOf('c'), mat.calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/satellite_bus")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, new ItemStack(LogisticsBridge.craftingManager), new Object[]{"IlI", "cec", "ili", Character.valueOf('I'), AE2Plugin.INSTANCE.api.definitions().blocks().iface().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('l'), mat.logicProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('i'), "ingotIron", Character.valueOf('e'), mat.engProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('c'), mat.calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)}).setRegistryName(new ResourceLocation("logisticsbridge", "recipes/crafting_manager_ae")));
    }

    public static SetIDPacket.IIdPipe processReqIDList(EntityPlayer player, RequestIDListPacket pck) {
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(pck.side - 1));
        IPartHost ph = (IPartHost)pck.getTileAs(player.field_70170_p, IPartHost.class);
        if (ph == null) {
            return null;
        }
        IPart p = ph.getPart(side);
        if (p instanceof SetIDPacket.IIdPipe) {
            return (SetIDPacket.IIdPipe)p;
        }
        return null;
    }

    public static void processResIDMod(EntityPlayer player, SetIDPacket pck) {
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(pck.side - 1));
        IPartHost ph = (IPartHost)pck.getTileAs(player.field_70170_p, IPartHost.class);
        if (ph == null) {
            return;
        }
        IPart p = ph.getPart(side);
        if (p instanceof SetIDPacket.IIdPipe) {
            ((SetIDPacket.IIdPipe)p).setPipeID(pck.id, pck.pid, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void hideFakeItems(GuiScreenEvent.BackgroundDrawnEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiMEMonitorable) {
            GuiMEMonitorable g = (GuiMEMonitorable)mc.field_71462_r;
            if (HIDE_FAKE_ITEM == null) {
                HIDE_FAKE_ITEM = new HideFakeItem();
            }
            try {
                ItemRepo r = (ItemRepo)ClientProxy.guiMEMonitorableRepo.get(g);
                IPartitionList pl = (IPartitionList)ClientProxy.itemRepoMyPartitionList.get(r);
                if (pl instanceof MergedPriorityList) {
                    MergedPriorityList ml = (MergedPriorityList)pl;
                    Collection negative = (Collection)MergedPriorityList_negative.get(ml);
                    if (!negative.contains(HIDE_FAKE_ITEM)) {
                        negative.add(HIDE_FAKE_ITEM);
                        r.updateView();
                    }
                } else {
                    MergedPriorityList mlist = new MergedPriorityList();
                    ClientProxy.itemRepoMyPartitionList.set(r, mlist);
                    if (pl != null) {
                        mlist.addNewList(pl, true);
                    }
                    mlist.addNewList((IPartitionList)HIDE_FAKE_ITEM, false);
                    r.updateView();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadModels() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175599_af().func_175037_a().func_178086_a((Item)ItemPart.instance, 1024, (ModelResourceLocation)SATELLITE_BUS.getItemModels().get(0));
        ModelLoader.setCustomModelResourceLocation((Item)ItemPart.instance, (int)1024, (ModelResourceLocation)((ModelResourceLocation)SATELLITE_BUS.getItemModels().get(0)));
    }

    static class StackSize
    implements IAEItemStack {
        private long ss;

        StackSize() {
        }

        public long getStackSize() {
            return this.ss;
        }

        public IAEItemStack setStackSize(long stackSize) {
            this.ss = stackSize;
            return this;
        }

        public long getCountRequestable() {
            return 0L;
        }

        public IAEItemStack setCountRequestable(long countRequestable) {
            return this;
        }

        public boolean isCraftable() {
            return false;
        }

        public IAEItemStack setCraftable(boolean isCraftable) {
            return this;
        }

        public IAEItemStack reset() {
            return this;
        }

        public boolean isMeaningful() {
            return false;
        }

        public void incStackSize(long i) {
            this.ss += i;
        }

        public void decStackSize(long i) {
            this.ss -= i;
        }

        public void incCountRequestable(long i) {
        }

        public void decCountRequestable(long i) {
        }

        public void writeToNBT(NBTTagCompound i) {
        }

        public boolean fuzzyComparison(IAEItemStack other, FuzzyMode mode) {
            return false;
        }

        public void writeToPacket(ByteBuf data) {
        }

        public IAEItemStack empty() {
            return this;
        }

        public boolean isItem() {
            return false;
        }

        public boolean isFluid() {
            return false;
        }

        public IStorageChannel<IAEItemStack> getChannel() {
            return null;
        }

        public ItemStack asItemStackRepresentation() {
            return ItemStack.field_190927_a;
        }

        public ItemStack createItemStack() {
            return ItemStack.field_190927_a;
        }

        public boolean hasTagCompound() {
            return false;
        }

        public void add(IAEItemStack option) {
        }

        public IAEItemStack copy() {
            return new StackSize().setStackSize(this.ss);
        }

        public Item getItem() {
            return Items.field_190931_a;
        }

        public int getItemDamage() {
            return 0;
        }

        public boolean sameOre(IAEItemStack is) {
            return false;
        }

        public boolean isSameType(IAEItemStack otherStack) {
            return false;
        }

        public boolean isSameType(ItemStack stored) {
            return false;
        }

        public ItemStack getDefinition() {
            return ItemStack.field_190927_a;
        }
    }
}

