/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.IFoodProviderBlock;
import com.animania.api.interfaces.IFoodProviderTE;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.config.AnimaniaConfig;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GenericAIFindWater<T extends EntityCreature & ISleeping>
extends GenericAISearchBlock {
    private final T entity;
    private final double speed;
    private int waterFindTimer;
    private boolean isRunning;
    private EntityAIBase eatAI;
    private Class parentClass;
    private boolean halfAmount;

    public GenericAIFindWater(T entity, double speedIn, @Nullable EntityAIBase eatAI, Class parentClass, boolean halfAmount) {
        super((EntityCreature)entity, speedIn, AnimaniaConfig.gameRules.aiBlockSearchRange, true, EnumFacing.UP);
        this.entity = entity;
        this.speed = speedIn;
        this.func_75248_a(3);
        this.waterFindTimer = 0;
        this.eatAI = eatAI;
        this.parentClass = parentClass;
        this.halfAmount = halfAmount;
    }

    public GenericAIFindWater(T entity, double speedIn, @Nullable EntityAIBase eatAI, Class parentClass) {
        this(entity, speedIn, eatAI, parentClass, false);
    }

    @Override
    public boolean func_75250_a() {
        if (++this.waterFindTimer <= AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            return false;
        }
        if (((IFoodEating)this.entity).getWatered() || this.entity.func_184207_aI() || ((ISleeping)this.entity).getSleeping() || AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)this.entity).getInteracted()) {
            this.waterFindTimer = 0;
            return false;
        }
        if (this.entity.func_70681_au().nextInt(3) != 0) {
            return false;
        }
        this.waterFindTimer = 0;
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && !((IFoodEating)this.entity).getWatered();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isAtDestination()) {
            IFoodProviderTE trough;
            TileEntity te;
            this.creature.func_70671_ap().func_75650_a((double)this.seekingBlockPos.func_177958_n() + 0.5, (double)this.seekingBlockPos.func_177956_o(), (double)this.seekingBlockPos.func_177952_p() + 0.5, 10.0f, (float)this.creature.func_70646_bf());
            IBlockState state = this.world.func_180495_p(this.seekingBlockPos);
            Block block = state.func_177230_c();
            if (block instanceof IFoodProviderBlock && (te = this.world.func_175625_s(this.seekingBlockPos)) != null && te instanceof IFoodProviderTE && (trough = (IFoodProviderTE)te).canConsume(new FluidStack(FluidRegistry.WATER, this.halfAmount ? 50 : 100), null)) {
                trough.consumeLiquid(this.halfAmount ? 50 : 100);
                ((EntityCreature)this.entity).field_70170_p.func_175666_e(this.seekingBlockPos, block);
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setWatered(true);
                ((IFoodEating)this.entity).setInteracted(true);
                this.waterFindTimer = 0;
            }
            if (block == Blocks.field_150355_j) {
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setWatered(true);
                if (AnimaniaConfig.gameRules.waterRemovedAfterDrinking && !this.halfAmount) {
                    ((EntityCreature)this.entity).field_70170_p.func_175698_g(this.seekingBlockPos);
                }
                this.waterFindTimer = 0;
            }
        }
    }

    @Override
    protected boolean shouldMoveTo(World world, BlockPos pos) {
        TileEntity te;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof IFoodProviderBlock && (te = world.func_175625_s(pos)) != null && te instanceof IFoodProviderTE && ((IFoodProviderTE)te).canConsume(new FluidStack(FluidRegistry.WATER, this.halfAmount ? 50 : 100), null);
    }

    @Override
    protected boolean shouldMoveToSecondary(World worldIn, BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Biome biome = this.world.func_180494_b(pos);
        return block == Blocks.field_150355_j && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
    }
}

