/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.IFoodProviderBlock;
import com.animania.api.interfaces.IFoodProviderTE;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.blocks.fluids.BlockFluidBase;
import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.config.AnimaniaConfig;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class GenericAIFindFood<T extends EntityCreature & ISleeping>
extends GenericAISearchBlock {
    private final T entity;
    private int foodDelay;
    private EntityAIBase eatAI;
    private boolean eatBlocks;

    public GenericAIFindFood(T entity, double speedIn, @Nullable EntityAIBase eatAI, boolean eatBlocks) {
        super((EntityCreature)entity, speedIn, AnimaniaConfig.gameRules.aiBlockSearchRange, eatBlocks, EnumFacing.field_176754_o);
        this.entity = entity;
        this.func_75248_a(3);
        this.foodDelay = 0;
        this.eatAI = eatAI;
        this.eatBlocks = eatBlocks;
    }

    @Override
    public boolean func_75250_a() {
        if (++this.foodDelay <= AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            return false;
        }
        if (((IFoodEating)this.entity).getFed() || this.entity.func_184207_aI() || ((ISleeping)this.entity).getSleeping() || AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)this.entity).getInteracted()) {
            this.foodDelay = 0;
            return false;
        }
        if (this.entity.func_70681_au().nextInt(3) != 0) {
            return false;
        }
        this.foodDelay = 0;
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && !((IFoodEating)this.entity).getFed();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isAtDestination()) {
            IFoodProviderTE trough;
            TileEntity te;
            this.creature.func_70671_ap().func_75650_a((double)this.seekingBlockPos.func_177958_n() + 0.5, (double)this.seekingBlockPos.func_177956_o(), (double)this.seekingBlockPos.func_177952_p() + 0.5, 10.0f, (float)this.creature.func_70646_bf());
            IBlockState state = this.world.func_180495_p(this.seekingBlockPos);
            Block block = state.func_177230_c();
            if (block instanceof IFoodProviderBlock && (te = this.world.func_175625_s(this.seekingBlockPos)) != null && te instanceof IFoodProviderTE && (trough = (IFoodProviderTE)te).canConsume(((IFoodEating)this.entity).getFoodItems(), ((IFoodEating)this.entity).getFoodFluids())) {
                trough.consumeSolidOrLiquid(100, 1);
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setLiquidFed(true);
                ((IFoodEating)this.entity).setFed(true);
                ((IFoodEating)this.entity).setHandFed(true);
                ((IFoodEating)this.entity).setInteracted(true);
                ((EntityCreature)this.entity).field_70170_p.func_175666_e(this.seekingBlockPos, block);
                this.foodDelay = 0;
                return;
            }
            if (this.isBlockFood(block)) {
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setFed(true);
                if (AnimaniaConfig.gameRules.plantsRemovedAfterEating) {
                    ((EntityCreature)this.entity).field_70170_p.func_175655_b(this.seekingBlockPos, false);
                }
                this.foodDelay = 0;
                return;
            }
            if (block instanceof BlockFluidBase) {
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setFed(true);
                ((IFoodEating)this.entity).setLiquidFed(true);
                ((EntityCreature)this.entity).field_70170_p.func_175655_b(this.seekingBlockPos, false);
                this.foodDelay = 0;
                return;
            }
        }
    }

    @Override
    protected boolean shouldMoveTo(World world, BlockPos pos) {
        TileEntity te;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof IFoodProviderBlock && (te = world.func_175625_s(pos)) != null && te instanceof IFoodProviderTE && ((IFoodProviderTE)te).canConsume(((IFoodEating)this.entity).getFoodItems(), ((IFoodEating)this.entity).getFoodFluids());
    }

    @Override
    protected boolean shouldMoveToSecondary(World worldIn, BlockPos pos) {
        Fluid[] foodFluids;
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase && (foodFluids = ((IFoodEating)this.entity).getFoodFluids()) != null && foodFluids.length > 0) {
            BlockFluidBase fluidBlock = (BlockFluidBase)block;
            int level = (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
            if (level == 0) {
                Fluid fluid = fluidBlock.getFluid();
                for (Fluid f : foodFluids) {
                    if (!f.equals(fluid)) continue;
                    return true;
                }
            }
        }
        return this.eatBlocks && this.isBlockFood(block);
    }

    public boolean isBlockFood(Block block) {
        Class[] foodBlocks;
        for (Class c : foodBlocks = ((IFoodEating)this.entity).getFoodBlocks()) {
            if (!c.isInstance(block)) continue;
            return true;
        }
        return false;
    }
}

