/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.helper.ReflectionUtil;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class GenericAIEatGrass<T extends EntityCreature & IFoodEating>
extends GenericAISearchBlock {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    protected final T grassEaterEntity;
    protected final World entityWorld;
    public int eatingGrassTimer;
    public boolean eatsGrass;
    private int timer;
    private boolean isEating = false;

    public GenericAIEatGrass(T grassEaterEntityIn, boolean eatsGrass) {
        super((EntityCreature)grassEaterEntityIn, 1.0, 8, EnumFacing.UP);
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = ((EntityCreature)grassEaterEntityIn).field_70170_p;
        this.eatsGrass = eatsGrass;
        this.func_75248_a(7);
    }

    public GenericAIEatGrass(T grassEaterEntityIn) {
        this(grassEaterEntityIn, true);
    }

    @Override
    public boolean func_75250_a() {
        if (++this.timer <= AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            return false;
        }
        if (((ISleeping)this.grassEaterEntity).getSleeping() || ((IFoodEating)this.grassEaterEntity).getFed()) {
            this.timer = 0;
            return false;
        }
        if (this.grassEaterEntity.func_70681_au().nextInt(120) == 0) {
            this.timer = 0;
            return super.func_75250_a();
        }
        return false;
    }

    @Override
    public void func_75249_e() {
        if (!this.destinationBlock.equals((Object)NO_POS) && this.eatsGrass) {
            super.func_75249_e();
        } else {
            this.eatingGrassTimer = 160;
            this.entityWorld.func_72960_a(this.grassEaterEntity, (byte)10);
            this.grassEaterEntity.func_70661_as().func_75499_g();
        }
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() || this.eatingGrassTimer > 0;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.eatingGrassTimer = 0;
        this.isEating = false;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.timer = 0;
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.isAtDestination() && this.shouldMoveTo(this.world, this.seekingBlockPos)) {
            IBlockState state = this.world.func_180495_p(this.seekingBlockPos);
            Block block = state.func_177230_c();
            if (!this.isEating) {
                this.eatingGrassTimer = 160;
                this.entityWorld.func_72960_a(this.grassEaterEntity, (byte)10);
                this.grassEaterEntity.func_70661_as().func_75499_g();
                this.isEating = true;
            }
            if (this.eatsGrass && this.eatingGrassTimer == 4) {
                this.entityWorld.func_175718_b(2001, this.seekingBlockPos, Block.func_149682_b((Block)block));
                if (AnimaniaConfig.gameRules.plantsRemovedAfterEating) {
                    String name = block.getRegistryName().toString();
                    boolean handled = false;
                    if (Loader.isModLoaded((String)"desirepaths") && (name.startsWith("desirepaths:grass_worn_") && !name.endsWith("6") || block instanceof BlockGrass)) {
                        try {
                            ReflectionUtil.findMethod(Class.forName("com.corosus.desirepaths.block.BlockGrassWorn"), "performWearTick", null, World.class, BlockPos.class, Float.TYPE).invoke(null, this.entityWorld, this.seekingBlockPos, Float.valueOf(20.0f));
                            handled = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!handled) {
                        this.entityWorld.func_180501_a(this.seekingBlockPos, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                }
                if (this.grassEaterEntity instanceof IFoodEating) {
                    this.func_75249_e();
                    ((IFoodEating)this.grassEaterEntity).setFed(true);
                }
                this.grassEaterEntity.func_70615_aA();
            }
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof BlockGrass || AddonInjectionHandler.runInjection("farm", "isMooshroom", Boolean.class, this.grassEaterEntity, block) != false || this.handleDesirePaths(block);
    }

    private boolean handleDesirePaths(Block block) {
        String name;
        return Loader.isModLoaded((String)"desirepaths") && (name = block.getRegistryName().toString()).contains("desirepaths:grass_worn_") && (name.endsWith("1") || name.endsWith("2") || name.endsWith("3"));
    }
}

