/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.handler.BlockHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockStraw
extends Block {
    protected static final AxisAlignedBB STRAW_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.002, 1.0);
    private String name = "block_straw";
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockStraw() {
        super(Material.field_151594_q);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.STRAW)));
        this.setRegistryName(new ResourceLocation("animania", this.name));
        this.func_149647_a(Animania.TabAnimaniaResources);
        BlockHandler.blocks.add(this);
        this.func_149663_c("animania_" + this.name);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        ItemBlock item = new ItemBlock((Block)this);
        item.setRegistryName(new ResourceLocation("animania", this.name));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.func_177958_n() + 0.25;
            double d1 = (double)pos.func_177956_o() + Animania.RANDOM.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.25;
            double d3 = 0.52;
            double d4 = Animania.RANDOM.nextDouble() * 0.6 - 0.3;
            worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d0, d1 + 0.75, d2 + d4, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)BlockHandler.blockSeeds.func_176223_P())});
        }
        return this.func_176223_P();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockHandler.blockStraw);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STRAW_AABB;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        BlockPos blockposlower = pos.func_177977_b();
        return worldIn.func_180495_p(blockposlower).func_177230_c() != BlockHandler.blockStraw && worldIn.func_180495_p(blockposlower).func_177230_c().func_149730_j(worldIn.func_180495_p(blockposlower)) && worldIn.func_180495_p(blockposlower).func_177230_c().func_149662_c(worldIn.func_180495_p(blockposlower));
    }

    public String getName() {
        return this.name;
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        this.checkForDrop(world, observerPos, observerState);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case STRAW: {
                return new ItemStack(BlockHandler.blockStraw);
            }
        }
        return new ItemStack(BlockHandler.blockStraw);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public static enum EnumType implements IStringSerializable
    {
        STRAW(0, MapColor.field_151673_t, "straw");

        private static final EnumType[] META;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor mapColor;

        private EnumType(int i, MapColor color, String name) {
            this(i, color, name, name);
        }

        private EnumType(int meta, MapColor color, String name, String name2) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = name2;
            this.mapColor = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META.length) {
                meta = 0;
            }
            return META[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockstone$enumtype;
                EnumType.META[blockstone$enumtype.getMetadata()] = blockstone$enumtype = enumTypeArray[i];
            }
        }
    }
}

