/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityNest;
import com.animania.compat.top.providers.TOPInfoProvider;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class BlockNest
extends BlockContainer
implements TOPInfoProvider {
    private String name = "block_nest";
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);

    public BlockNest() {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        BlockHandler.blocks.add((Block)this);
        this.func_149663_c("animania_" + this.name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149675_a(true);
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)"tile.animania_block_nest.name");
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null && te.getNestContent() != TileEntityNest.NestContent.EMPTY) {
            AddonInjectionHandler.runInjection("farm", "nestHatchChickens", Void.class, new Object[]{te, worldIn, pos, state, rand});
            AddonInjectionHandler.runInjection("extra", "nestHatchPeafowl", Void.class, new Object[]{te, worldIn, pos, state, rand});
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNest();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlockHandler.blockNest, 1);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.itemHandler.getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockHandler.blockNest);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null && heldItem.func_190926_b() && !playerIn.func_70093_af()) {
            ItemStack stack = te.itemHandler.extractItem(0, 1, false);
            AnimaniaHelper.addItem(playerIn, stack);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityNest) {
            TileEntityNest nest = (TileEntityNest)te;
            ItemStack stack = nest.itemHandler.getStackInSlot(0);
            if (mode == ProbeMode.NORMAL && !stack.func_190926_b()) {
                probeInfo.horizontal();
                probeInfo.item(stack);
                if (nest.birdType != null) {
                    probeInfo.text("From: " + nest.birdType.toString().substring(0, 1).toUpperCase() + nest.birdType.toString().substring(1).toLowerCase());
                }
            }
        }
    }
}

