/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.tileEntity;

import com.animania.client.events.RenderEvents;
import com.animania.client.models.ModelTrough;
import com.animania.common.tileentities.TileEntityTrough;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityTroughRenderer
extends TileEntitySpecialRenderer<TileEntityTrough> {
    private static final ResourceLocation TROUGH_EMPTY_TEXTURE = new ResourceLocation("animania:textures/entity/tileentities/block_trough.png");
    private static final ResourceLocation WHEAT = new ResourceLocation("animania:textures/entity/tileentities/wheat.png");
    public static TileEntityTroughRenderer instance;
    private final ModelTrough trough = new ModelTrough();
    private static Map<TileEntityTrough, Color> cachedColors;

    public void render(TileEntityTrough te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(te.func_145832_p() & 7));
        this.renderTrough(te, (float)x, (float)y, (float)z, enumfacing, destroyStage, partialTicks);
    }

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        super.func_147497_a(rendererDispatcherIn);
        instance = this;
    }

    public void renderTrough(TileEntityTrough te, float x, float y, float z, EnumFacing facing, int destroyStage, float animateTicks) {
        FluidStack fluid;
        ModelTrough modelbase = this.trough;
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        Float rot = Float.valueOf(0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        } else {
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179137_b((double)((double)x + 1.5), (double)(y + 1.5f), (double)((double)z + 0.5));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179137_b((double)((double)x - 0.5), (double)(y + 1.5f), (double)((double)z + 0.5));
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179137_b((double)((double)x + 0.5), (double)(y + 1.5f), (double)((double)z - 0.5));
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                default: {
                    GlStateManager.func_179137_b((double)((double)x + 0.5), (double)(y + 1.5f), (double)((double)z + 1.5));
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        }
        float f = 0.0625f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TROUGH_EMPTY_TEXTURE);
        modelbase.func_78088_a(null, animateTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (te.getTroughContent() == TileEntityTrough.TroughContent.LIQUID && (fluid = te.fluidHandler.getFluid()) != null) {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
            ResourceLocation loc = new ResourceLocation(fluid.getFluid().getStill().func_110624_b() + ":textures/" + fluid.getFluid().getStill().func_110623_a() + ".png");
            double multi = 0.3122 * (1.0 - (double)fluid.amount / 1000.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.4, (double)1.0, (double)-0.3);
            GlStateManager.func_179137_b((double)0.0, (double)multi, (double)0.0);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            TileEntityTroughRenderer.drawTextureAtlasSprite(0.0, 0.0, sprite, 0.6, 1.0);
            TileEntityTroughRenderer.drawTextureAtlasSprite(-0.8, 0.0, sprite, 0.6, 0.8);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (te.getTroughContent() == TileEntityTrough.TroughContent.FOOD) {
            GlStateManager.func_179094_E();
            ItemStack stack = te.itemHandler.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                Color foodColor;
                GlStateManager.func_179141_d();
                GlStateManager.func_179089_o();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (RenderEvents.ticks % 20L == 0L) {
                    foodColor = this.getAverageColor(stack);
                    cachedColors.put(te, foodColor);
                }
                if ((foodColor = cachedColors.get(te)) == null) {
                    foodColor = this.getAverageColor(stack);
                    cachedColors.put(te, foodColor);
                }
                this.func_147499_a(TROUGH_EMPTY_TEXTURE);
                if (stack.func_77973_b() == Items.field_151015_O) {
                    this.trough.renderFeed(stack.func_190916_E(), new Color(160, 124, 89));
                } else {
                    this.trough.renderFeed(stack.func_190916_E(), foodColor);
                }
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null).func_177554_e();
                if (stack.func_77973_b() == Items.field_151015_O) {
                    this.func_147499_a(WHEAT);
                } else {
                    this.func_147499_a(new ResourceLocation(sprite.func_94215_i().replace(":", ":textures/") + ".png"));
                }
                this.trough.renderFood(0.0625f, stack.func_190916_E());
                GlStateManager.func_179129_p();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private static void drawTextureAtlasSprite(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double height, double width) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        double u = textureSprite.func_94212_f() - textureSprite.func_94209_e();
        double v = textureSprite.func_94210_h() - textureSprite.func_94206_g();
        double u0 = textureSprite.func_94209_e();
        double u1 = u0 + u * width;
        double v0 = textureSprite.func_94206_g();
        double v1 = v0 + v * height;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        bufferbuilder.func_181662_b(xCoord, yCoord, 0.0).func_187315_a(u1, v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(xCoord + width, yCoord, 0.0).func_187315_a(u0, v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(xCoord + width, yCoord + height, 0.0).func_187315_a(u0, v0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(xCoord, yCoord + height, 0.0).func_187315_a(u1, v0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public Color getAverageColor(ItemStack item) {
        BufferedImage image;
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(item, null, null).func_177554_e();
            ResourceLocation loc = new ResourceLocation(sprite.func_94215_i().replace(":", ":textures/") + ".png");
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
            image = ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Color(0, 0, 0);
        }
        int x1 = image.getWidth();
        int y1 = image.getHeight();
        double sumr = 0.0;
        double sumg = 0.0;
        double sumb = 0.0;
        for (int x = 0; x < x1; ++x) {
            for (int y = 0; y < y1; ++y) {
                Color pixel = new Color(image.getRGB(x, y), true);
                double alpha = (double)pixel.getAlpha() / 255.0;
                sumr += (double)pixel.getRed() * alpha;
                sumg += (double)pixel.getGreen() * alpha;
                sumb += (double)pixel.getBlue() * alpha;
            }
        }
        int num = image.getWidth() * image.getHeight();
        return new Color((int)sumr / num, (int)sumg / num, (int)sumb / num).brighter().brighter().brighter();
    }

    static {
        cachedColors = new HashMap<TileEntityTrough, Color>();
    }
}

