/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.handler;

import com.animania.api.data.Pose;
import com.animania.api.rendering.ModelPose;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="animania", value={Side.CLIENT})
public class AnimationHandler {
    private static final Map<Pair, ModelPose> handlers = new HashMap<Pair, ModelPose>();

    @SubscribeEvent
    public static void onWorldLeave(WorldEvent.Unload event) {
        handlers.clear();
    }

    public static ModelPose getOrCreatePose(Entity entity, Pose pose, Supplier<ModelPose> poseSupplier) {
        Pair pair = new Pair(entity, pose);
        if (handlers.containsKey(pair)) {
            return handlers.get(pair);
        }
        ModelPose p = (ModelPose)poseSupplier.get();
        handlers.put(pair, p);
        return p;
    }

    private static class Pair {
        UUID e;
        Pose p;

        public Pair(Entity e, Pose p) {
            this.e = e.func_110124_au();
            this.p = p;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.e == null ? 0 : this.e.hashCode());
            result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return other.e.equals(this.e) && other.p == other.p;
        }
    }
}

