/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilitySpeechData;
import org.orecruncher.dsurround.capabilities.speech.ISpeechData;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.WorldUtils;

public class PacketSpeechBubble
implements IMessage {
    protected int entityId;
    protected String message;

    public PacketSpeechBubble() {
    }

    public PacketSpeechBubble(@Nonnull Entity player2, @Nonnull String message) {
        this.entityId = player2.func_145782_y();
        this.message = message;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.entityId = buf.readInt();
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketSpeechBubble, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketSpeechBubble message, @Nullable MessageContext ctx) {
            if (ctx != null && ModOptions.speechbubbles.enableSpeechBubbles) {
                ModBase.proxy().getThreadListener(ctx).func_152344_a(() -> {
                    World world = EnvironStateHandler.EnvironState.getWorld();
                    if (world != null) {
                        Entity entity = WorldUtils.locateEntity((World)world, (int)message.entityId);
                        if (!(entity instanceof EntityPlayer)) {
                            return;
                        }
                        ISpeechData data = CapabilitySpeechData.getCapability(entity);
                        if (data != null) {
                            data.addMessage(message.message, (int)(ModOptions.speechbubbles.speechBubbleDuration * 20.0f));
                        }
                    }
                });
            }
            return null;
        }
    }
}

