/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.capabilities.CapabilityEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.WorldUtils;

public class PacketEntityData
implements IMessage {
    private int entityId;
    private boolean isAttacking;
    private boolean isFleeing;

    public PacketEntityData() {
    }

    public PacketEntityData(@Nonnull IEntityData data) {
        this.entityId = data.getEntityId();
        this.isAttacking = data.isAttacking();
        this.isFleeing = data.isFleeing();
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.entityId = buf.readInt();
        this.isAttacking = buf.readBoolean();
        this.isFleeing = buf.readBoolean();
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isAttacking);
        buf.writeBoolean(this.isFleeing);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketEntityData, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketEntityData message, @Nullable MessageContext ctx) {
            if (ctx != null) {
                ModBase.proxy().getThreadListener(ctx).func_152344_a(() -> {
                    IEntityDataSettable data;
                    Entity entity;
                    World world = EnvironStateHandler.EnvironState.getWorld();
                    if (world != null && (entity = WorldUtils.locateEntity((World)world, (int)message.entityId)) != null && (data = (IEntityDataSettable)CapabilityEntityData.getCapability(entity)) != null) {
                        data.setAttacking(message.isAttacking);
                        data.setFleeing(message.isFleeing);
                    }
                });
            }
            return null;
        }
    }
}

