/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.renderer;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import org.orecruncher.dsurround.capabilities.CapabilitySpeechData;
import org.orecruncher.dsurround.capabilities.speech.ISpeechData;
import org.orecruncher.dsurround.capabilities.speech.RenderContext;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.gfx.OpenGlState;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dsurround")
public class SpeechDataRenderer {
    private static final Color B_COLOR = Color.getColor((TextFormatting)TextFormatting.BLACK);
    private static final float B_COLOR_ALPHA = 0.5f;
    private static final Color F_COLOR = Color.getColor((TextFormatting)TextFormatting.GOLD);
    private static final float F_COLOR_ALPHA = 0.99f;
    private static final Color F_COLOR_DEPTH = Color.getColor((TextFormatting)TextFormatting.GRAY);

    private static RenderManager getRenderManager() {
        return Minecraft.func_71410_x().func_175598_ae();
    }

    private static double interpX() {
        return SpeechDataRenderer.getRenderManager().field_78730_l;
    }

    private static double interpY() {
        return SpeechDataRenderer.getRenderManager().field_78731_m;
    }

    private static double interpZ() {
        return SpeechDataRenderer.getRenderManager().field_78728_n;
    }

    private static boolean isThirdPersonView() {
        GameSettings settings = SpeechDataRenderer.getRenderManager().field_78733_k;
        return settings != null && settings.field_74320_O == 2;
    }

    private static void doRender(@Nonnull Entity entity, @Nonnull ISpeechData data, float partialTicks) {
        RenderContext ctx = data.getRenderContext();
        if (ctx == null || ctx.numberOfMessages == 0) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float pitch = SpeechDataRenderer.getRenderManager().field_78732_j * (float)(SpeechDataRenderer.isThirdPersonView() ? -1 : 1);
        float yaw = -SpeechDataRenderer.getRenderManager().field_78735_i;
        float locX = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks - SpeechDataRenderer.interpX());
        float locY = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks - SpeechDataRenderer.interpY());
        float locZ = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks - SpeechDataRenderer.interpZ());
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179109_b((float)locX, (float)(locY + entity.field_70131_O + 0.25f), (float)locZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = -1.0f;
        GlStateManager.func_179139_a((double)-0.015, (double)-0.015f, (double)-0.015);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        float red = SpeechDataRenderer.B_COLOR.red;
        float green = SpeechDataRenderer.B_COLOR.green;
        float blue = SpeechDataRenderer.B_COLOR.blue;
        float alpha = 0.5f;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(ctx.left, ctx.top, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(ctx.left, ctx.bottom, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(ctx.right, ctx.top, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(ctx.right, ctx.bottom, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.05f);
        ObjectArray<String> text = data.getText();
        int lines = ctx.numberOfMessages;
        for (int t = 0; t < ctx.numberOfMessages; ++t) {
            String str = (String)text.get(t);
            int offset = -lines * 9;
            int margin = -font.func_78256_a(str) / 2;
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            font.func_78276_b(str, margin, offset, F_COLOR_DEPTH.rgbWithAlpha(0.99f));
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            font.func_78276_b(str, margin, offset, F_COLOR.rgbWithAlpha(0.99f));
            --lines;
        }
        OpenGlState.pop((OpenGlState)glState);
    }

    private static boolean canBeSeen(@Nonnull EntityPlayer player2, @Nonnull Entity subject) {
        if (subject.func_98034_c(player2)) {
            return false;
        }
        return player2.func_70685_l(subject);
    }

    @SubscribeEvent
    public static void onRenderWorldLast(@Nonnull RenderWorldLastEvent event) {
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        if (player2 != null) {
            int range = 256;
            ObjectArray entities = WorldUtils.gatherEntitiesInView((Entity)player2, (int)256, (float)event.getPartialTicks());
            for (Entity e : entities) {
                ISpeechData data = CapabilitySpeechData.getCapability(e);
                if (data == null || !SpeechDataRenderer.canBeSeen(player2, e)) continue;
                SpeechDataRenderer.doRender(e, data, event.getPartialTicks());
            }
        }
    }
}

