/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleBubbleJet;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class BubbleJetEffect
extends JetEffect {
    public BubbleJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.BUBBLE_JET;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (state.func_185904_a().func_76224_d()) {
            boolean isSolidBlock = provider.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
            return isSolidBlock && super.canTrigger(provider, state, pos, random);
        }
        return false;
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int liquidBlocks = BubbleJetEffect.countBlocks(provider, pos, s -> s.func_185904_a().func_76224_d(), 1);
        if (liquidBlocks > 0) {
            ParticleBubbleJet effect = new ParticleBubbleJet(liquidBlocks, provider.getWorld(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            this.addEffect(effect);
        }
    }
}

