/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.footsteps.IFootstepAccentProvider;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.item.IArmorItemData;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.ItemUtils;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class ArmorAccents
implements IFootstepAccentProvider {
    @Override
    @Nonnull
    public String getName() {
        return "Armor Accents";
    }

    @Nullable
    protected IAcoustic resolveArmor(@Nonnull ItemStack stack) {
        IItemData id = ItemUtils.getItemData(stack.func_77973_b());
        if (id instanceof IArmorItemData) {
            return ((IArmorItemData)((Object)id)).getArmorSound(stack);
        }
        return null;
    }

    protected IAcoustic resolveFootArmor(@Nonnull ItemStack stack) {
        IItemData id = ItemUtils.getItemData(stack.func_77973_b());
        if (id instanceof IArmorItemData) {
            return ((IArmorItemData)((Object)id)).getFootArmorSound(stack);
        }
        return null;
    }

    @Override
    public void provide(@Nonnull EntityLivingBase entity, @Nullable BlockPos pos, @Nonnull ObjectArray<IAcoustic> in) {
        ItemStack foot;
        ItemStack armor;
        if (!ModOptions.sound.enableArmorSounds) {
            return;
        }
        if (EnvironStateHandler.EnvironState.isPlayer((Entity)entity)) {
            armor = EnvironStateHandler.EnvironState.getPlayerItemStack();
            foot = EnvironStateHandler.EnvironState.getPlayerFootArmorStack();
        } else {
            armor = ItemClass.effectiveArmorStack(entity);
            foot = ItemClass.footArmorStack(entity);
        }
        IAcoustic armorAddon = this.resolveArmor(armor);
        IAcoustic footAddon = this.resolveFootArmor(foot);
        if (armorAddon != null) {
            in.add((Object)armorAddon);
            if (armorAddon == footAddon) {
                footAddon = null;
            }
        }
        if (footAddon != null) {
            in.add((Object)footAddon);
        }
    }
}

