/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.entitydata;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;
import org.orecruncher.lib.ReflectedField;

public final class EntityDataTables {
    private static final ReflectedField.ObjectField<EntityAITasks, Set<EntityAITasks.EntityAITaskEntry>> executingTasks = new ReflectedField.ObjectField(EntityAITasks.class, "executingTaskEntries", "field_75780_b");
    private static final Map<Class<?>, TaskType> AI_TASKS = new Reference2ObjectOpenHashMap(128);
    private static final Map<String, TaskType> MAPPINGS = new Object2ObjectOpenHashMap();

    private static void add(@Nonnull Class<?> clazz, @Nonnull TaskType ct) {
        AI_TASKS.put(clazz, ct);
    }

    private static void add(@Nonnull Class<? extends EntityLiving> clazz, @Nonnull TaskType ct, String ... className) {
        for (String cn : className) {
            String name = EntityDataTables.resolveName(clazz) + "$" + cn;
            MAPPINGS.put(name, ct);
        }
    }

    private static String resolveName(@Nonnull Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return i > 0 ? n.substring(i + 1) : n;
    }

    @Nonnull
    private static TaskType find(@Nonnull EntityAIBase aiTask) {
        Class<?> clazz = aiTask.getClass();
        TaskType ct = AI_TASKS.get(clazz);
        if (ct == null) {
            String name;
            for (Map.Entry<Class<?>, TaskType> kvp : AI_TASKS.entrySet()) {
                if (!kvp.getKey().isInstance(aiTask)) continue;
                ct = kvp.getValue();
                break;
            }
            if (ct == null && (ct = MAPPINGS.get(name = EntityDataTables.resolveName(clazz))) == null) {
                ct = TaskType.None;
            }
            AI_TASKS.put(clazz, ct);
        }
        return ct;
    }

    private static boolean eval(@Nonnull EntityLiving entity, @Nonnull TaskType desiredType) {
        for (EntityAITasks.EntityAITaskEntry task : (Set)executingTasks.get((Object)entity.field_70714_bg)) {
            if (EntityDataTables.find(task.field_75733_a) != desiredType) continue;
            return true;
        }
        for (EntityAITasks.EntityAITaskEntry task : (Set)executingTasks.get((Object)entity.field_70715_bh)) {
            if (EntityDataTables.find(task.field_75733_a) != desiredType) continue;
            return true;
        }
        return false;
    }

    public static void assess(@Nonnull IEntityDataSettable data) {
        EntityLiving entity = data.getEntity();
        boolean isAttacking = EntityDataTables.eval(entity, TaskType.Attack);
        boolean isFleeing = EntityDataTables.eval(entity, TaskType.Flee);
        data.setAttacking(isAttacking);
        data.setFleeing(isFleeing);
    }

    static {
        EntityDataTables.add(EntityAIAttackMelee.class, TaskType.Attack);
        EntityDataTables.add(EntityAIAttackRanged.class, TaskType.Attack);
        EntityDataTables.add(EntityAIAttackRangedBow.class, TaskType.Attack);
        EntityDataTables.add(EntityAICreeperSwell.class, TaskType.Attack);
        EntityDataTables.add(EntityAILeapAtTarget.class, TaskType.Attack);
        EntityDataTables.add(EntityAIOcelotAttack.class, TaskType.Attack);
        EntityDataTables.add(EntityAIOwnerHurtByTarget.class, TaskType.Attack);
        EntityDataTables.add(EntityAIZombieAttack.class, TaskType.Attack);
        EntityDataTables.add(EntityAINearestAttackableTarget.class, TaskType.Attack);
        EntityDataTables.add(EntitySpellcasterIllager.AICastingApell.class, TaskType.Attack);
        EntityDataTables.add(EntitySpellcasterIllager.AIUseSpell.class, TaskType.Attack);
        EntityDataTables.add(EntityAIAvoidEntity.class, TaskType.Flee);
        EntityDataTables.add(EntityAIFleeSun.class, TaskType.Flee);
        EntityDataTables.add(EntityAIHurtByTarget.class, TaskType.Flee);
        EntityDataTables.add(EntityAIPanic.class, TaskType.Flee);
        EntityDataTables.add(EntityAIRunAroundLikeCrazy.class, TaskType.Flee);
        EntityDataTables.add(EntityRabbit.class, TaskType.Attack, "AIEvilAttack", "a");
        EntityDataTables.add(EntityRabbit.class, TaskType.Flee, "AIAvoidEntity", "b");
        EntityDataTables.add(EntityRabbit.class, TaskType.Flee, "AIPanic", "f");
        EntityDataTables.add(EntityPolarBear.class, TaskType.Attack, "AIMeleeAttack", "d");
        EntityDataTables.add(EntityPolarBear.class, TaskType.Attack, "AIAttackPlayer", "a");
        EntityDataTables.add(EntityPolarBear.class, TaskType.Flee, "AIPanic", "e");
        EntityDataTables.add(EntityShulker.class, TaskType.Attack, "AIAttack", "a");
        EntityDataTables.add(EntityShulker.class, TaskType.Attack, "AIDefenseAttack", "c");
        EntityDataTables.add(EntityShulker.class, TaskType.Attack, "AIAttackNearest", "d");
        EntityDataTables.add(EntityEvoker.class, TaskType.Attack, "AICastingSpell", "b");
        EntityDataTables.add(EntityEvoker.class, TaskType.Attack, "AISummonSpell", "c");
        EntityDataTables.add(EntityEvoker.class, TaskType.Attack, "AIAttackSpell", "a");
        EntityDataTables.add(EntityEvoker.class, TaskType.Attack, "AIWololoSpell", "d");
        EntityDataTables.add(EntityEnderman.class, TaskType.Attack, "AIFindPlayer", "b");
        EntityDataTables.add(EntityGhast.class, TaskType.Attack, "AIFireballAttack", "c");
        EntityDataTables.add(EntityGuardian.class, TaskType.Attack, "AIGuardianAttack", "a");
        EntityDataTables.add(EntitySlime.class, TaskType.Attack, "AISlimeAttack", "a");
        EntityDataTables.add(EntitySpider.class, TaskType.Attack, "AISpiderAttack", "a");
        EntityDataTables.add(EntityBlaze.class, TaskType.Attack, "AIFireballAttack", "a");
        EntityDataTables.add(EntityVex.class, TaskType.Attack, "AIChargeAttack", "a");
        EntityDataTables.add(EntityVindicator.class, TaskType.Attack, "AIJohnnyAttack", "a");
        EntityDataTables.add(EntityWolf.class, TaskType.Flee, "AIAvoidEntity", "a");
    }

    private static enum TaskType {
        None,
        Attack,
        Flee;

    }
}

