/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockColoring;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.block.ISustainsPlantType;
import biomesoplenty.common.item.ItemBOPBlock;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPGrass
extends BlockGrass
implements IBOPBlock,
ISustainsPlantType {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BOPGrassType.class);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176498_a, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        BOPGrassType grassType = (BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT));
        switch (grassType) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case OVERGROWN_STONE: 
            case MYCELIAL_NETHERRACK: {
                return grassType.func_176610_l();
            }
        }
        return grassType.func_176610_l() + "_grass_block";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public BlockBOPGrass() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176498_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.LOAMY)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case OVERGROWN_STONE: 
            case MYCELIAL_NETHERRACK: {
                return SoundType.field_185851_d;
            }
        }
        return SoundType.field_185850_c;
    }

    public Material func_149688_o(IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case OVERGROWN_STONE: 
            case MYCELIAL_NETHERRACK: {
                return Material.field_151576_e;
            }
        }
        return Material.field_151577_b;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public String getHarvestTool(IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case OVERGROWN_STONE: 
            case MYCELIAL_NETHERRACK: {
                return "pickaxe";
            }
        }
        return "shovel";
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OVERGROWN_NETHERRACK: 
            case MYCELIAL_NETHERRACK: {
                return 0.4f;
            }
            case OVERGROWN_STONE: {
                return 1.5f;
            }
            case SPECTRAL_MOSS: {
                return 3.0f;
            }
        }
        return 0.6f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OVERGROWN_NETHERRACK: 
            case MYCELIAL_NETHERRACK: {
                return 0.1f;
            }
            case OVERGROWN_STONE: {
                return 2.0f;
            }
            case SPECTRAL_MOSS: {
                return 3.0f;
            }
        }
        return 0.12f;
    }

    @Override
    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OVERGROWN_NETHERRACK: 
            case MYCELIAL_NETHERRACK: {
                if (plantType != EnumPlantType.Nether) break;
                return true;
            }
        }
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return !world.func_175623_d(pos.func_177974_f()) && world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177976_e()) && world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177978_c()) && world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177968_d()) && world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            default: 
        }
        return state;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.spreadGrass(world, pos, state, rand, 4, 1, 3, 1);
    }

    public void spreadGrass(World world, BlockPos pos, IBlockState state, Random rand, int tries, int xzSpread, int downSpread, int upSpread) {
        if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
            world.func_175656_a(pos, BlockBOPGrass.getDirtBlockState(state));
        } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < tries; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(xzSpread * 2 + 1) - xzSpread, rand.nextInt(downSpread + upSpread + 1) - downSpread, rand.nextInt(xzSpread * 2 + 1) - xzSpread);
                IBlockState target = world.func_180495_p(pos1);
                IBlockState blockAboveTarget = world.func_180495_p(pos1.func_177984_a());
                IBlockState targetGrass = BlockBOPGrass.spreadsToGrass(state, target);
                if (targetGrass == null) break;
                if (world.func_175671_l(pos1.func_177984_a()) < 4 || blockAboveTarget.getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2) continue;
                world.func_175656_a(pos1, targetGrass);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case MYCELIAL_NETHERRACK: {
                return false;
            }
        }
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case MYCELIAL_NETHERRACK: {
                return false;
            }
        }
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos startPos = pos.func_177984_a();
        for (int i = 0; i < 128; ++i) {
            int walkLength = i / 16;
            BlockPos currPos = startPos;
            boolean walkOk = true;
            for (int j = 0; j < walkLength; ++j) {
                Block currBlockBelow = worldIn.func_180495_p((currPos = currPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c();
                if ((currBlockBelow == Blocks.field_150349_c || currBlockBelow == BOPBlocks.grass) && !worldIn.func_180495_p(currPos).func_185915_l()) continue;
                walkOk = false;
                break;
            }
            if (!walkOk || !worldIn.func_175623_d(currPos)) continue;
            if (rand.nextInt(8) == 0) {
                worldIn.func_180494_b(currPos).plantFlower(worldIn, rand, currPos);
                continue;
            }
            IBlockState tallgrassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
            if (!Blocks.field_150329_H.func_180671_f(worldIn, currPos, tallgrassState)) continue;
            worldIn.func_175656_a(currPos, tallgrassState);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
                case LOAMY: 
                case SANDY: 
                case SILTY: {
                    effectRenderer.func_180533_a(pos, BlockBOPGrass.getDirtBlockState(state));
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OVERGROWN_STONE: {
                return Item.func_150898_a((Block)Blocks.field_150347_e.func_176223_P().func_177230_c());
            }
        }
        return Item.func_150898_a((Block)BlockBOPGrass.getDirtBlock(state));
    }

    public int func_180651_a(IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OVERGROWN_STONE: {
                return 0;
            }
        }
        return BlockBOPGrass.getDirtBlockMeta(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (state.func_177229_b((IProperty)VARIANT) == BOPGrassType.MYCELIAL_NETHERRACK && rand.nextInt(10) == 0) {
            world.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static IBlockState getDirtBlockState(IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: {
                return Blocks.field_150377_bs.func_176223_P();
            }
            case LOAMY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
            }
            case SANDY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SANDY));
            }
            case SILTY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
            }
            case OVERGROWN_NETHERRACK: 
            case MYCELIAL_NETHERRACK: {
                return Blocks.field_150424_aL.func_176223_P();
            }
            case OVERGROWN_STONE: {
                return Blocks.field_150348_b.func_176223_P();
            }
        }
        return Blocks.field_150346_d.func_176203_a(BlockDirt.DirtType.DIRT.func_176925_a());
    }

    public static Block getDirtBlock(IBlockState state) {
        return BlockBOPGrass.getDirtBlockState(state).func_177230_c();
    }

    public static int getDirtBlockMeta(IBlockState state) {
        return BlockBOPGrass.getDirtBlock(state).func_176201_c(BlockBOPGrass.getDirtBlockState(state));
    }

    public static IBlockState spreadsToGrass(IBlockState source, IBlockState target) {
        switch ((BOPGrassType)((Object)source.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case OVERGROWN_STONE: 
            case MYCELIAL_NETHERRACK: {
                break;
            }
            case LOAMY: 
            case SANDY: 
            case SILTY: {
                if (target.func_177230_c() == Blocks.field_150346_d && target.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
                    return Blocks.field_150349_c.func_176223_P();
                }
                if (target.func_177230_c() != BOPBlocks.dirt) break;
                return BlockBOPDirt.getGrassBlockState(target);
            }
            case ORIGIN: {
                if ((target.func_177230_c() != Blocks.field_150346_d || target.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT) && (target.func_177230_c() != BOPBlocks.dirt || !Boolean.FALSE.equals(target.func_177229_b((IProperty)BlockBOPDirt.COARSE)))) break;
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.ORIGIN));
            }
            case DAISY: {
                if ((target.func_177230_c() != Blocks.field_150346_d || target.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT) && (target.func_177230_c() != BOPBlocks.dirt || !Boolean.FALSE.equals(target.func_177229_b((IProperty)BlockBOPDirt.COARSE)))) break;
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.DAISY));
            }
        }
        return null;
    }

    public static enum BOPGrassType implements IStringSerializable
    {
        SPECTRAL_MOSS,
        OVERGROWN_STONE,
        LOAMY,
        SANDY,
        SILTY,
        ORIGIN,
        OVERGROWN_NETHERRACK,
        DAISY,
        MYCELIAL_NETHERRACK;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

